/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.reactive.messaging.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.DotName;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.microprofile.reactive.messaging._private.MicroProfileReactiveMessagingLogger;
import org.wildfly.microprofile.reactive.messaging.common.ReactiveMessagingAttachments;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ReactiveMessagingDependencyProcessor
implements DeploymentUnitProcessor {
    private final boolean allowExperimental = true;
    private static final String EXPERIMENTAL_PROPERTY = "jboss.as.reactive.messaging.experimental";
    private static final List<DotName> REACTIVE_MESSAGING_ANNOTATIONS;
    private static final List<DotName> BANNED_REACTIVE_MESSAGING_ANNOTATIONS;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (this.isReactiveMessagingDeployment(deploymentUnit)) {
            this.addModuleDependencies(deploymentUnit);
            deploymentUnit.putAttachment(ReactiveMessagingAttachments.IS_REACTIVE_MESSAGING_DEPLOYMENT, (Object)true);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addModuleDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.eclipse.microprofile.reactive-messaging.api", false, false, true, false));
        moduleSpecification.addSystemDependency(this.cdiDependency(new ModuleDependency(moduleLoader, "io.smallrye.reactive.messaging", false, false, true, false)));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "io.smallrye.config", false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.eclipse.microprofile.config.api", false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "io.reactivex.rxjava2.rxjava", false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "io.smallrye.reactive.mutiny.reactive-streams-operators", false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.wildfly.reactive.messaging.config", false, false, true, false));
        this.addDependenciesForIntermediateModule(moduleSpecification, moduleLoader, "io.smallrye.reactive.messaging.connector");
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "io.vertx.client", true, false, true, false));
    }

    private void addDependenciesForIntermediateModule(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String intermediateModuleName) {
        try {
            Module module = moduleLoader.loadModule(intermediateModuleName);
            for (DependencySpec dep : module.getDependencies()) {
                if (!(dep instanceof ModuleDependencySpec)) continue;
                ModuleDependencySpec mds = (ModuleDependencySpec)dep;
                ModuleDependency md = this.cdiDependency(new ModuleDependency(moduleLoader, mds.getName(), mds.isOptional(), false, true, false));
                moduleSpecification.addSystemDependency(md);
            }
        }
        catch (ModuleLoadException e) {
            MicroProfileReactiveMessagingLogger.LOGGER.intermediateModuleNotPresent(intermediateModuleName);
        }
    }

    private boolean isReactiveMessagingDeployment(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        boolean allowExperimentalAnnotations = this.allowExperimentalAnnotations();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName dotName : BANNED_REACTIVE_MESSAGING_ANNOTATIONS) {
            if (index.getAnnotations(dotName).isEmpty()) continue;
            if (allowExperimentalAnnotations) {
                MicroProfileReactiveMessagingLogger.LOGGER.debugf("Deployment '%s' is a MicroProfile Reactive Messaging deployment \u2013 @%s annotation found.", deploymentUnit.getName(), dotName);
                return true;
            }
            throw MicroProfileReactiveMessagingLogger.LOGGER.experimentalAnnotationNotAllowed(dotName);
        }
        for (DotName dotName : REACTIVE_MESSAGING_ANNOTATIONS) {
            if (index.getAnnotations(dotName).isEmpty()) continue;
            MicroProfileReactiveMessagingLogger.LOGGER.debugf("Deployment '%s' is a MicroProfile Reactive Messaging deployment \u2013 @%s annotation found.", deploymentUnit.getName(), dotName);
            return true;
        }
        MicroProfileReactiveMessagingLogger.LOGGER.debugf("Deployment '%s' is not a MicroProfile Reactive Messaging deployment.", deploymentUnit.getName());
        return false;
    }

    private ModuleDependency cdiDependency(ModuleDependency moduleDependency) {
        moduleDependency.addImportFilter(s -> s.equals("META-INF"), true);
        return moduleDependency;
    }

    private boolean allowExperimentalAnnotations() throws DeploymentUnitProcessingException {
        boolean experimental = WildFlySecurityManager.isChecking() ? (Boolean)WildFlySecurityManager.doChecked(() -> Boolean.getBoolean(EXPERIMENTAL_PROPERTY)) : Boolean.getBoolean(EXPERIMENTAL_PROPERTY);
        if (experimental) {
            // empty if block
        }
        return experimental;
    }

    static {
        ArrayList<DotName> annotations = new ArrayList<DotName>();
        String rmPackage = "org.eclipse.microprofile.reactive.messaging.";
        annotations.add(DotName.createSimple((String)(rmPackage + "Acknowledgment")));
        annotations.add(DotName.createSimple((String)(rmPackage + "Channel")));
        annotations.add(DotName.createSimple((String)(rmPackage + "Incoming")));
        annotations.add(DotName.createSimple((String)(rmPackage + "Outgoing")));
        annotations.add(DotName.createSimple((String)(rmPackage + "OnOverflow")));
        REACTIVE_MESSAGING_ANNOTATIONS = Collections.unmodifiableList(annotations);
        String spiPackage = "org.eclipse.microprofile.reactive.messaging.spi.";
        annotations.add(DotName.createSimple((String)(spiPackage + "Connector")));
        annotations.add(DotName.createSimple((String)(spiPackage + "ConnectorAttribute")));
        annotations.add(DotName.createSimple((String)(spiPackage + "ConnectorAttributes")));
        ArrayList<DotName> banned = new ArrayList<DotName>();
        String smallryePackage = "io.smallrye.reactive.messaging.annotations.";
        banned.add(DotName.createSimple((String)(smallryePackage + "Blocking")));
        banned.add(DotName.createSimple((String)(smallryePackage + "Broadcast")));
        banned.add(DotName.createSimple((String)(smallryePackage + "Channel")));
        banned.add(DotName.createSimple((String)(smallryePackage + "ConnectorAttribute")));
        banned.add(DotName.createSimple((String)(smallryePackage + "ConnectorAttributes")));
        banned.add(DotName.createSimple((String)(smallryePackage + "Incomings")));
        banned.add(DotName.createSimple((String)(smallryePackage + "Merge")));
        banned.add(DotName.createSimple((String)(smallryePackage + "OnOverflow")));
        BANNED_REACTIVE_MESSAGING_ANNOTATIONS = Collections.unmodifiableList(banned);
    }
}

