/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.Map;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FacetMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.NumericFieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class SortableFieldMapping {
    private final String fieldName;
    private final PropertyDescriptor property;
    private final EntityDescriptor entity;
    private final SearchMapping mapping;

    public SortableFieldMapping(String fieldName, PropertyDescriptor property, EntityDescriptor entity, SearchMapping mapping) {
        this.fieldName = fieldName;
        this.property = property;
        this.entity = entity;
        this.mapping = mapping;
        Map<String, Object> sortableField = Collections.singletonMap("forField", fieldName);
        property.addSortableField(sortableField);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public NumericFieldMapping numericField() {
        return new NumericFieldMapping(this.fieldName, this.property, this.entity, this.mapping);
    }

    public FacetMapping facet() {
        return new FacetMapping(this.fieldName, this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

