/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.util.impl.SearchThreadFactory;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class Executors {
    public static final int QUEUE_MAX_LENGTH = 1000;
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private Executors() {
    }

    public static ThreadPoolExecutor newFixedThreadPool(int threads, String groupname) {
        return Executors.newFixedThreadPool(threads, groupname, 1000);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int threads, String groupname, int queueSize) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new SearchThreadFactory(groupname), new BlockPolicy());
    }

    public static ScheduledExecutorService newScheduledThreadPool(String groupname) {
        return new ScheduledThreadPoolExecutor(1, new SearchThreadFactory(groupname));
    }

    public static ThreadPoolExecutor newScalableThreadPool(int threadsMin, int threadsMax, String groupname, int queueSize) {
        return new ThreadPoolExecutor(threadsMin, threadsMax, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new SearchThreadFactory(groupname), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static class BlockPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException e1) {
                log.interruptedWorkError(r);
                Thread.currentThread().interrupt();
            }
        }
    }
}

