/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

interface ProtoStreamWriterContext
extends ProtoStreamOperation.Context,
AutoCloseable {
    public static final ThreadLocal<Factory> FACTORY = new ThreadLocal<Factory>(){

        @Override
        protected Factory initialValue() {
            return new DefaultFactory();
        }

        class DefaultFactory
        implements Factory {
            final Map<Class<?>, ProtoStreamWriterContext> contexts = new IdentityHashMap(2);

            DefaultFactory() {
            }

            @Override
            public ProtoStreamWriterContext apply(ProtoStreamWriter writer) {
                return this.contexts.computeIfAbsent(writer.getClass(), x$0 -> new DefaultProtoStreamWriterContext((Class<?>)x$0));
            }

            class DefaultProtoStreamWriterContext
            implements ProtoStreamWriterContext,
            Function<Object, Integer> {
                private final Class<?> writerClass;
                private final Map<Object, Integer> references = new IdentityHashMap<Object, Integer>(64);
                private int index = 0;

                DefaultProtoStreamWriterContext(Class<?> targetClass) {
                    this.writerClass = targetClass;
                }

                @Override
                public Integer getReference(Object object) {
                    return this.references.get(object);
                }

                @Override
                public void addReference(Object object) {
                    this.references.computeIfAbsent(object, this);
                }

                @Override
                public Integer apply(Object key) {
                    return this.index++;
                }

                @Override
                public void close() {
                    DefaultFactory.this.contexts.remove(this.writerClass);
                }
            }
        }
    };

    public Integer getReference(Object var1);

    @Override
    public void close();

    public static interface Factory
    extends Function<ProtoStreamWriter, ProtoStreamWriterContext>,
    AutoCloseable {
        @Override
        default public void close() {
            FACTORY.remove();
        }
    }
}

