/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AbstractJACCModuleDelegate;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class WebJACCPolicyModuleDelegate
extends AbstractJACCModuleDelegate {
    private Policy policy = Policy.getPolicy();
    private HttpServletRequest request = null;
    private CodeSource webCS = null;
    private String canonicalRequestURI = null;

    @Override
    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof WebResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(WebResource.class.getName());
        }
        WebResource webResource = (WebResource)resource;
        Map<String, Object> map = resource.getMap();
        if (map == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("resourceMap");
        }
        this.request = (HttpServletRequest)webResource.getServletRequest();
        this.webCS = webResource.getCodeSource();
        this.canonicalRequestURI = webResource.getCanonicalRequestURI();
        String roleName = (String)map.get("roleName");
        Principal principal = (Principal)map.get("hasRole.Principal");
        Set roles = (Set)map.get("principal.roles");
        String servletName = webResource.getServletName();
        Boolean resourceCheck = this.checkBooleanValue((Boolean)map.get("resourcePermissionCheck"));
        Boolean userDataCheck = this.checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        this.validatePermissionChecks(resourceCheck, userDataCheck, roleRefCheck);
        boolean decision = false;
        try {
            if (resourceCheck.booleanValue()) {
                decision = this.hasResourcePermission(callerSubject, role);
            } else if (userDataCheck.booleanValue()) {
                decision = this.hasUserDataPermission();
            } else if (roleRefCheck.booleanValue()) {
                decision = this.hasRole(principal, roleName, roles, servletName);
            } else {
                PicketBoxLogger.LOGGER.debugInvalidWebJaccCheck();
            }
        }
        catch (IOException ioe) {
            PicketBoxLogger.LOGGER.debugIgnoredException(ioe);
        }
        return decision ? 1 : -1;
    }

    @Override
    public void setPolicyRegistrationManager(PolicyRegistration authzM) {
        this.policyRegistration = authzM;
    }

    private boolean checkPolicy(Permission perm, Principal requestPrincpal, Subject caller, Role role) {
        Principal[] principals = this.getPrincipals(caller, role);
        return this.checkPolicy(perm, principals);
    }

    private boolean checkPolicy(Permission perm, Principal[] principals) {
        ProtectionDomain pd = new ProtectionDomain(this.webCS, null, null, principals);
        return this.policy.implies(pd, perm);
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private boolean hasResourcePermission(Subject caller, Role role) throws IOException {
        Principal requestPrincipal = this.request.getUserPrincipal();
        WebResourcePermission perm = new WebResourcePermission(this.canonicalRequestURI, this.request.getMethod());
        boolean allowed = this.checkPolicy((Permission)perm, requestPrincipal, caller, role);
        if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
            PicketBoxLogger.LOGGER.traceHasResourcePermission(perm.toString(), allowed);
        }
        return allowed;
    }

    private boolean hasRole(Principal principal, String roleName, Set<Principal> roles, String servletName) {
        if (servletName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("servletName");
        }
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, roleName);
        Principal[] principals = new Principal[]{principal};
        if (roles != null) {
            principals = new Principal[roles.size()];
            roles.toArray(principals);
        }
        boolean allowed = this.checkPolicy((Permission)perm, principals);
        PicketBoxLogger.LOGGER.traceHasRolePermission(perm.toString(), allowed);
        return allowed;
    }

    private boolean hasUserDataPermission() throws IOException {
        WebUserDataPermission perm = new WebUserDataPermission(this.canonicalRequestURI, this.request.getMethod());
        boolean ok = false;
        try {
            Principal[] principals = null;
            ok = this.checkPolicy((Permission)perm, principals);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
            PicketBoxLogger.LOGGER.traceHasUserDataPermission(perm.toString(), ok);
        }
        return ok;
    }

    private void validatePermissionChecks(Boolean resourceCheck, Boolean userDataCheck, Boolean roleRefCheck) {
        if (resourceCheck == Boolean.TRUE && userDataCheck == Boolean.TRUE && roleRefCheck == Boolean.TRUE || resourceCheck == Boolean.TRUE && userDataCheck == Boolean.TRUE || userDataCheck == Boolean.TRUE && roleRefCheck == Boolean.TRUE) {
            throw PicketBoxMessages.MESSAGES.invalidPermissionChecks();
        }
    }
}

