/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Timer;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.HttpClient;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionDrivenDynamicHTTPMetadataResolver
extends AbstractDynamicHTTPMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(FunctionDrivenDynamicHTTPMetadataResolver.class);
    private Function<CriteriaSet, String> requestURLBuilder;

    public FunctionDrivenDynamicHTTPMetadataResolver(HttpClient client) {
        this(null, client);
    }

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer, client);
        this.setRequestURLBuilder(new HTTPEntityIDRequestURLBuilder());
    }

    @Nonnull
    public Function<CriteriaSet, String> getRequestURLBuilder() {
        return this.requestURLBuilder;
    }

    public void setRequestURLBuilder(@Nonnull Function<CriteriaSet, String> builder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.requestURLBuilder = (Function)Constraint.isNotNull(builder, (String)"Request URL builder function was null");
    }

    @Override
    @Nullable
    protected String buildRequestURL(@Nonnull CriteriaSet criteria) {
        String url = (String)this.getRequestURLBuilder().apply((Object)criteria);
        this.log.debug("{} URL generated by request builder was: {}", (Object)this.getLogPrefix(), (Object)url);
        return url;
    }
}

