/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.util.JMSMessageConverter;
import org.apache.cxf.transport.jms.util.JMSUtil;

final class JMSMessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSMessageUtils.class);

    private JMSMessageUtils() {
    }

    public static org.apache.cxf.message.Message asCXFMessage(Message message, String jmsHeadersKey) throws UnsupportedEncodingException, JMSException {
        MessageImpl inMessage = new MessageImpl();
        JMSMessageHeadersType messageHeaders = JMSMessageHeadersType.from(message);
        inMessage.put((Object)jmsHeadersKey, (Object)messageHeaders);
        JMSMessageUtils.populateIncomingContext(messageHeaders, (org.apache.cxf.message.Message)inMessage);
        JMSMessageUtils.retrieveAndSetPayload((org.apache.cxf.message.Message)inMessage, message);
        return inMessage;
    }

    private static void retrieveAndSetPayload(org.apache.cxf.message.Message inMessage, Message message) throws UnsupportedEncodingException, JMSException {
        String messageType = null;
        Object converted = new JMSMessageConverter().fromMessage(message);
        if (converted instanceof String) {
            inMessage.setContent(Reader.class, (Object)new StringReader((String)converted));
            messageType = "text";
        } else if (converted instanceof byte[]) {
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream((byte[])converted));
            messageType = "byte";
        } else {
            messageType = "unknown";
        }
        Map headers = CastUtils.cast((Map)((Map)inMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        headers.put("JMSMessageType", Collections.singletonList(messageType));
    }

    private static void populateIncomingContext(JMSMessageHeadersType messageHeaders, org.apache.cxf.message.Message inMessage) throws UnsupportedEncodingException {
        String responseCode;
        String contentType = messageHeaders.getContentType();
        if (contentType != null) {
            inMessage.put((Object)"Content-Type", (Object)contentType);
            inMessage.put((Object)org.apache.cxf.message.Message.ENCODING, (Object)JMSMessageUtils.getEncoding(contentType));
        }
        if ((responseCode = (String)messageHeaders.getProperty(org.apache.cxf.message.Message.RESPONSE_CODE)) != null) {
            inMessage.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, (Object)Integer.valueOf(responseCode));
        }
        TreeMap<String, List<String>> protHeaders = new TreeMap<String, List<String>>();
        for (String name : messageHeaders.getPropertyKeys()) {
            String val = (String)messageHeaders.getProperty(name);
            protHeaders.put(name, Collections.singletonList(val));
        }
        String requestURI = messageHeaders.getSOAPJMSRequestURI();
        if (requestURI != null) {
            try {
                JMSEndpoint endpoint = new JMSEndpoint(requestURI);
                if (endpoint.getTargetService() != null) {
                    protHeaders.put("target.service.inrequesturi", Collections.singletonList("true"));
                }
                inMessage.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
            }
            catch (Exception e) {
                protHeaders.put("malformed.requesturi", Collections.singletonList("true"));
            }
        }
        inMessage.put((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, protHeaders);
    }

    static String getEncoding(String ct) throws UnsupportedEncodingException {
        String enc = HttpHeaderHelper.findCharset((String)ct);
        String normalizedEncoding = HttpHeaderHelper.mapCharset((String)enc, (String)StandardCharsets.UTF_8.name());
        if (normalizedEncoding == null) {
            String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
            LOG.log(Level.WARNING, m);
            throw new UnsupportedEncodingException(m);
        }
        return normalizedEncoding;
    }

    private static String getContentType(org.apache.cxf.message.Message message) {
        TreeMap headers;
        String contentType = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)org.apache.cxf.message.Message.ENCODING);
        if (null != contentType) {
            if (enc != null && contentType.indexOf("charset=") == -1 && !contentType.toLowerCase().contains("multipart/related")) {
                contentType = contentType + "; charset=" + enc;
            }
        } else {
            contentType = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        if (null == (headers = CastUtils.cast((Map)((Map)message.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS))))) {
            headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, headers);
        }
        return contentType;
    }

    private static String getContentEncoding(org.apache.cxf.message.Message message) {
        List l;
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (headers != null && (l = (List)headers.get("Content-Encoding")) != null && !l.isEmpty()) {
            return (String)l.get(0);
        }
        return null;
    }

    public static Message asJMSMessage(JMSConfiguration jmsConfig, org.apache.cxf.message.Message outMessage, Object payload, String messageType, Session session, String correlationId, String headerType) throws JMSException {
        boolean isSoapMessage;
        Message jmsMessage = JMSUtil.createAndSetPayload(payload, session, messageType);
        JMSMessageHeadersType messageHeaders = JMSMessageUtils.getOrCreateHeader(outMessage, headerType);
        if (!messageHeaders.isSetJMSDeliveryMode()) {
            messageHeaders.setJMSDeliveryMode(jmsConfig.getDeliveryMode());
        }
        if (!messageHeaders.isSetTimeToLive()) {
            messageHeaders.setTimeToLive(jmsConfig.getTimeToLive());
        }
        if (!messageHeaders.isSetJMSPriority()) {
            messageHeaders.setJMSPriority(jmsConfig.getPriority());
        }
        Map headers = CastUtils.cast((Map)((Map)outMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        boolean bl = isSoapMessage = !PropertyUtils.isTrue((Object)outMessage.getExchange().get((Object)"org.apache.cxf.rest.message"));
        if (isSoapMessage) {
            String soapAction;
            if (!messageHeaders.isSetSOAPJMSTargetService()) {
                messageHeaders.setSOAPJMSTargetService(jmsConfig.getTargetService());
            }
            if (!messageHeaders.isSetSOAPJMSBindingVersion()) {
                messageHeaders.setSOAPJMSBindingVersion("1.0");
            }
            messageHeaders.setSOAPJMSContentType(JMSMessageUtils.getContentType(outMessage));
            if (JMSMessageUtils.getContentEncoding(outMessage) != null) {
                messageHeaders.setSOAPJMSContentEncoding(JMSMessageUtils.getContentEncoding(outMessage));
            }
            if ((soapAction = JMSMessageUtils.getSoapAction(messageHeaders, outMessage, headers)) != null) {
                messageHeaders.setSOAPJMSSOAPAction(soapAction);
            }
            if (!messageHeaders.isSetSOAPJMSIsFault()) {
                boolean isFault = outMessage.getContent(Exception.class) != null;
                messageHeaders.setSOAPJMSIsFault(isFault);
            }
            if (!messageHeaders.isSetSOAPJMSRequestURI()) {
                messageHeaders.setSOAPJMSRequestURI(jmsConfig.getRequestURI());
            }
        } else {
            if (MessageUtils.isRequestor((org.apache.cxf.message.Message)outMessage)) {
                JMSMessageUtils.addJMSPropertiesFromMessage(messageHeaders, outMessage, "org.apache.cxf.request.method", "org.apache.cxf.request.uri", "Accept");
            } else {
                JMSMessageUtils.addJMSPropertyFromMessage(messageHeaders, outMessage, org.apache.cxf.message.Message.RESPONSE_CODE);
            }
            String contentType = (String)outMessage.remove((Object)"Content-Type");
            if (contentType != null) {
                outMessage.put((Object)"org.apache.cxf.jms.rs.ContentType", (Object)contentType);
            }
            JMSMessageUtils.addJMSPropertyFromMessage(messageHeaders, outMessage, "org.apache.cxf.jms.rs.ContentType");
            String contentLength = (String)outMessage.remove((Object)"Content-Length");
            if (contentLength != null) {
                outMessage.put((Object)"org.apache.cxf.jms.rs.ContentLength", (Object)contentLength);
            }
            JMSMessageUtils.addJMSPropertyFromMessage(messageHeaders, outMessage, "org.apache.cxf.jms.rs.ContentLength");
        }
        if (headers != null) {
            for (Map.Entry ent : headers.entrySet()) {
                if (((String)ent.getKey()).equals("Content-Type") || ((String)ent.getKey()).equals("Content-Length")) continue;
                messageHeaders.putProperty((String)ent.getKey(), String.join((CharSequence)",", (Iterable)ent.getValue()));
            }
        }
        messageHeaders.writeTo(jmsMessage);
        jmsMessage.setJMSCorrelationID(correlationId);
        return jmsMessage;
    }

    private static JMSMessageHeadersType getOrCreateHeader(org.apache.cxf.message.Message message, String headerName) {
        JMSMessageHeadersType messageProperties = (JMSMessageHeadersType)message.get((Object)headerName);
        if (messageProperties == null) {
            messageProperties = new JMSMessageHeadersType();
            message.put((Object)headerName, (Object)messageProperties);
        }
        return messageProperties;
    }

    private static String getSoapAction(JMSMessageHeadersType messageProperties, org.apache.cxf.message.Message outMessage, Map<String, List<String>> headers) {
        List<String> action;
        String soapAction = null;
        if (headers != null && (action = headers.remove("SOAPAction")) != null && !action.isEmpty()) {
            soapAction = action.get(0);
        }
        if (soapAction == null) {
            soapAction = messageProperties.getSOAPJMSSOAPAction();
        }
        if (soapAction == null) {
            soapAction = JMSMessageUtils.extractActionFromSoap12(outMessage);
        }
        return soapAction;
    }

    private static void addJMSPropertiesFromMessage(JMSMessageHeadersType messageProperties, org.apache.cxf.message.Message message, String ... keys) {
        for (String key : keys) {
            JMSMessageUtils.addJMSPropertyFromMessage(messageProperties, message, key);
        }
    }

    private static void addJMSPropertyFromMessage(JMSMessageHeadersType messageProperties, org.apache.cxf.message.Message message, String key) {
        Object value = message.get((Object)key);
        if (value != null) {
            messageProperties.putProperty(key, value.toString());
        }
    }

    public static String getMessageType(Message request) {
        String msgType = request instanceof TextMessage ? "text" : (request instanceof BytesMessage ? "byte" : "binary");
        return msgType;
    }

    private static String extractActionFromSoap12(org.apache.cxf.message.Message message) {
        String ct = (String)message.get((Object)"Content-Type");
        if (ct == null) {
            return null;
        }
        int start = ct.indexOf("action=");
        if (start != -1) {
            int end;
            if (ct.charAt(start + 7) == '\"') {
                end = ct.indexOf(34, start += 8);
            } else {
                end = ct.indexOf(59, start += 7);
                if (end == -1) {
                    end = ct.length();
                }
            }
            return ct.substring(start, end);
        }
        return null;
    }

    public static boolean isMtomEnabled(org.apache.cxf.message.Message message) {
        return MessageUtils.getContextualBoolean((org.apache.cxf.message.Message)message, (String)"mtom-enabled");
    }
}

