/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class JMXAccessControlList {
    private static final String WILDCARD = "*";
    private Access defaultAccess = new Access("*");
    private ConcurrentHashMap<String, TreeMap<String, Access>> domainAccess = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TreeMap<String, Access>> whitelist = new ConcurrentHashMap();
    private Comparator<String> keyComparator = (key1, key2) -> {
        boolean key1ContainsWildCard = key1.contains(WILDCARD);
        boolean key2ContainsWildcard = key2.contains(WILDCARD);
        if (key1ContainsWildCard && !key2ContainsWildcard) {
            return 1;
        }
        if (!key1ContainsWildCard && key2ContainsWildcard) {
            return -1;
        }
        if (key1ContainsWildCard && key2ContainsWildcard) {
            return key2.length() - key1.length();
        }
        return key1.length() - key2.length();
    };

    public void addToWhiteList(String domain, String key) {
        TreeMap<String, Object> domainMap = new TreeMap(this.keyComparator);
        if ((domainMap = this.whitelist.putIfAbsent(domain, domainMap)) == null) {
            domainMap = this.whitelist.get(domain);
        }
        Access access = new Access(domain, this.normalizeKey(key));
        domainMap.putIfAbsent(access.getKey(), access);
    }

    public List<String> getRolesForObject(ObjectName objectName, String methodName) {
        TreeMap<String, Access> domainMap = this.domainAccess.get(objectName.getDomain());
        if (domainMap != null) {
            Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
            for (Map.Entry<String, String> keyEntry : keyPropertyList.entrySet()) {
                String key = this.normalizeKey(keyEntry.getKey() + "=" + keyEntry.getValue());
                for (Access accessEntry : domainMap.values()) {
                    if (!accessEntry.getKeyPattern().matcher(key).matches()) continue;
                    return accessEntry.getMatchingRolesForMethod(methodName);
                }
            }
            Access access = domainMap.get("");
            if (access != null) {
                return access.getMatchingRolesForMethod(methodName);
            }
        }
        return this.defaultAccess.getMatchingRolesForMethod(methodName);
    }

    public boolean isInWhiteList(ObjectName objectName) {
        TreeMap<String, Access> domainMap = this.whitelist.get(objectName.getDomain());
        if (domainMap != null) {
            if (domainMap.containsKey("")) {
                return true;
            }
            Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
            for (Map.Entry<String, String> keyEntry : keyPropertyList.entrySet()) {
                String key = this.normalizeKey(keyEntry.getKey() + "=" + keyEntry.getValue());
                for (Access accessEntry : domainMap.values()) {
                    if (!accessEntry.getKeyPattern().matcher(key).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addToDefaultAccess(String method, String ... roles) {
        if (roles != null) {
            if (method.equals(WILDCARD)) {
                this.defaultAccess.addCatchAll(roles);
            } else if (method.endsWith(WILDCARD)) {
                String prefix = method.replace(WILDCARD, "");
                this.defaultAccess.addMethodsPrefixes(prefix, roles);
            } else {
                this.defaultAccess.addMethods(method, roles);
            }
        }
    }

    public void addToRoleAccess(String domain, String key, String method, String ... roles) {
        String accessKey;
        Access access;
        TreeMap<String, Object> domainMap = new TreeMap(this.keyComparator);
        if ((domainMap = this.domainAccess.putIfAbsent(domain, domainMap)) == null) {
            domainMap = this.domainAccess.get(domain);
        }
        if ((access = (Access)domainMap.get(accessKey = this.normalizeKey(key))) == null) {
            access = new Access(domain, accessKey);
            domainMap.put(accessKey, access);
        }
        if (method.equals(WILDCARD)) {
            access.addCatchAll(roles);
        } else if (method.endsWith(WILDCARD)) {
            String prefix = method.replace(WILDCARD, "");
            access.addMethodsPrefixes(prefix, roles);
        } else {
            access.addMethods(method, roles);
        }
    }

    private String normalizeKey(String key) {
        if (key == null) {
            return "";
        }
        if (key.endsWith("\"")) {
            return key.replace("\"", "");
        }
        return key;
    }

    public static JMXAccessControlList createDefaultList() {
        JMXAccessControlList accessControlList = new JMXAccessControlList();
        accessControlList.addToWhiteList("hawtio", "type=*");
        accessControlList.addToRoleAccess("org.apache.activemq.artemis", null, "list*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.artemis", null, "get*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.artemis", null, "is*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.artemis", null, "set*", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.artemis", null, WILDCARD, "amq");
        accessControlList.addToDefaultAccess("list*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("get*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("is*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("set*", "update", "amq");
        accessControlList.addToDefaultAccess(WILDCARD, "amq");
        return accessControlList;
    }

    static class Access {
        private final String id;
        private final String key;
        private final Pattern keyPattern;
        List<String> catchAllRoles = new ArrayList<String>();
        Map<String, List<String>> methodRoles = new HashMap<String, List<String>>();
        Map<String, List<String>> methodPrefixRoles = new LinkedHashMap<String, List<String>>();

        Access(String id) {
            this(id, "");
        }

        Access(String id, String key) {
            this.id = id;
            this.key = key;
            this.keyPattern = Pattern.compile(key.replace(JMXAccessControlList.WILDCARD, ".*"));
        }

        public synchronized void addMethods(String prefix, String ... roles) {
            List<String> rolesList = this.methodRoles.get(prefix);
            if (rolesList == null) {
                rolesList = new ArrayList<String>();
                this.methodRoles.put(prefix, rolesList);
            }
            for (String role : roles) {
                rolesList.add(role);
            }
        }

        public synchronized void addMethodsPrefixes(String prefix, String ... roles) {
            List<String> rolesList = this.methodPrefixRoles.get(prefix);
            if (rolesList == null) {
                rolesList = new ArrayList<String>();
                this.methodPrefixRoles.put(prefix, rolesList);
            }
            for (String role : roles) {
                rolesList.add(role);
            }
        }

        public void addCatchAll(String ... roles) {
            for (String role : roles) {
                this.catchAllRoles.add(role);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }

        public List<String> getMatchingRolesForMethod(String methodName) {
            List<String> roles = this.methodRoles.get(methodName);
            if (roles != null) {
                return roles;
            }
            for (Map.Entry<String, List<String>> entry : this.methodPrefixRoles.entrySet()) {
                if (!methodName.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return this.catchAllRoles;
        }
    }
}

