/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.connectors;

import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.vertx.mutiny.core.Vertx;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;

@ApplicationScoped
public class ExecutionHolder {
    private boolean internalVertxInstance = false;
    final Vertx vertx;

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=200) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.internalVertxInstance) {
            this.vertx.close().await().indefinitely();
        }
    }

    public ExecutionHolder() {
        this.vertx = null;
    }

    public ExecutionHolder(Vertx vertx) {
        this.vertx = vertx;
        this.internalVertxInstance = true;
    }

    @Inject
    public ExecutionHolder(Instance<Vertx> instanceOfVertx) {
        if (instanceOfVertx == null || instanceOfVertx.isUnsatisfied()) {
            this.internalVertxInstance = true;
            this.vertx = Vertx.vertx();
            ProviderLogging.log.vertXInstanceCreated();
        } else {
            this.vertx = (Vertx)instanceOfVertx.get();
        }
    }

    public Vertx vertx() {
        return this.vertx;
    }
}

