/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class DHGClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGClient(DHFactory factory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory delegate) {
        return new KeyExchangeFactory(){

            public String getName() {
                return delegate.getName();
            }

            @Override
            public KeyExchange createKeyExchange(Session session) throws Exception {
                return new DHGClient(delegate, session);
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(v_s, v_c, i_s, i_c);
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        byte[] e = this.updateE(this.dh.getE());
        Session s = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({})[{}] Send SSH_MSG_KEXDH_INIT", (Object)this, (Object)s);
        }
        Buffer buffer = s.createBuffer((byte)30, e.length + 32);
        buffer.putMPInt(e);
        s.writePacket(buffer);
    }

    protected AbstractDH getDH() throws Exception {
        return this.factory.create(new Object[0]);
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        String keyAlg;
        PublicKey serverKey;
        AbstractClientSession session = this.getClientSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, session, KeyExchange.getSimpleKexOpcodeName(cmd)});
        }
        if (cmd != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        byte[] k_s = buffer.getBytes();
        byte[] f = this.updateF(buffer);
        byte[] sig = buffer.getBytes();
        this.dh.setF(f);
        this.k = this.dh.getK();
        buffer = new ByteArrayBuffer(k_s);
        PublicKey serverPublicHostKey = serverKey = buffer.getRawPublicKey();
        if (serverKey instanceof OpenSshCertificate) {
            OpenSshCertificate openSshKey = (OpenSshCertificate)serverKey;
            serverPublicHostKey = openSshKey.getServerHostKey();
            try {
                this.verifyCertificate(session, openSshKey);
            }
            catch (SshException e) {
                if (((Boolean)CoreModuleProperties.ABORT_ON_INVALID_CERTIFICATE.getRequired((PropertyResolver)session)).booleanValue()) {
                    throw e;
                }
                serverKey = openSshKey.getServerHostKey();
                this.log.info("Ignoring invalid certificate {}", (Object)openSshKey.getId(), (Object)e);
            }
        }
        if (GenericUtils.isEmpty((CharSequence)(keyAlg = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS)))) {
            throw new SshException("Unsupported server key type: " + serverPublicHostKey.getAlgorithm() + "[" + serverPublicHostKey.getFormat() + "]");
        }
        buffer = new ByteArrayBuffer();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        buffer.putMPInt(this.getE());
        buffer.putMPInt(f);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        Signature verif = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create(session.getSignatureFactories(), (String)keyAlg), (String)"No verifier located for algorithm=%s", (Object)keyAlg);
        verif.initVerifier((SessionContext)session, serverPublicHostKey);
        verif.update((SessionContext)session, this.h);
        if (!verif.verify((SessionContext)session, sig)) {
            throw new SshException(3, "KeyExchange signature verification failed for key type=" + keyAlg);
        }
        session.setServerKey(serverKey);
        return true;
    }

    protected void verifyCertificate(Session session, OpenSshCertificate openSshKey) throws Exception {
        PublicKey signatureKey = openSshKey.getCaPubKey();
        String keyAlg = KeyUtils.getKeyType((Key)signatureKey);
        String keyId = openSshKey.getId();
        String variant = openSshKey.getSignatureAlg();
        if (!GenericUtils.isEmpty((CharSequence)variant) && "ssh-rsa".equals(KeyUtils.getCanonicalKeyType((String)variant))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("verifyCertificate({})[id={}] Allowing to use variant {} instead of {}", new Object[]{session, keyId, variant, keyAlg});
            }
        } else {
            throw new SshException(3, "Found invalid signature alg " + variant + " for key ID=" + keyId);
        }
        keyAlg = variant;
        Signature verif = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create((Collection)session.getSignatureFactories(), (String)keyAlg), (String)"No KeyExchange CA verifier located for algorithm=%s of key ID=%s", (Object[])new Object[]{keyAlg, keyId});
        verif.initVerifier((SessionContext)session, signatureKey);
        verif.update((SessionContext)session, openSshKey.getMessage());
        if (!verif.verify((SessionContext)session, openSshKey.getSignature())) {
            throw new SshException(3, "KeyExchange CA signature verification failed for key type=" + keyAlg + " of key ID=" + keyId);
        }
        if (openSshKey.getType() != 2) {
            throw new SshException(3, "KeyExchange signature verification failed, not a host key (2) " + openSshKey.getType() + " for key ID=" + keyId);
        }
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        if (openSshKey.getValidAfter() > now || now >= openSshKey.getValidBefore()) {
            throw new SshException(3, "KeyExchange signature verification failed, CA expired " + openSshKey.getValidAfterDate() + " - " + openSshKey.getValidBeforeDate() + " for key ID=" + keyId);
        }
        SocketAddress connectSocketAddress = this.getClientSession().getConnectAddress();
        if (connectSocketAddress instanceof SshdSocketAddress) {
            connectSocketAddress = ((SshdSocketAddress)connectSocketAddress).toInetSocketAddress();
        }
        if (connectSocketAddress instanceof InetSocketAddress) {
            String hostName = ((InetSocketAddress)connectSocketAddress).getHostString();
            Collection principals = openSshKey.getPrincipals();
            if (GenericUtils.isEmpty((Collection)principals) || !principals.contains(hostName)) {
                throw new SshException(3, "KeyExchange signature verification failed, invalid principal " + hostName + " for key ID=" + keyId + " - allowed=" + principals);
            }
        } else {
            throw new SshException(3, "KeyExchange signature verification failed, could not determine connect host for key ID=" + keyId);
        }
        if (!GenericUtils.isEmpty((Collection)openSshKey.getCriticalOptions())) {
            throw new SshException(3, "KeyExchange signature verification failed, unrecognized critical options " + openSshKey.getCriticalOptions() + " for key ID=" + keyId);
        }
    }
}

