/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;

public final class MiddleIdData {
    private final IdMapper originalMapper;
    private final IdMapper prefixedMapper;
    private final String entityName;
    private final String auditEntityName;

    public MiddleIdData(AuditEntitiesConfiguration verEntCfg, IdMappingData mappingData, String prefix, String entityName, boolean audited) {
        this.originalMapper = mappingData.getIdMapper();
        this.prefixedMapper = mappingData.getIdMapper().prefixMappedProperties(prefix);
        this.entityName = entityName;
        this.auditEntityName = audited ? verEntCfg.getAuditEntityName(entityName) : null;
    }

    public IdMapper getOriginalMapper() {
        return this.originalMapper;
    }

    public IdMapper getPrefixedMapper() {
        return this.prefixedMapper;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getAuditEntityName() {
        return this.auditEntityName;
    }

    public boolean isAudited() {
        return this.auditEntityName != null;
    }
}

