/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Test;

public class DivertTopicToQueueTest
extends JMSClientTestSupport {
    @Test
    public void divertTopicToQueueWithSelectorTest() throws Exception {
        String address1 = "bss.order.workorderchanges.v1.topic";
        String address2 = "bss.order.Consumer.cbma.workorderchanges.v1.queue";
        String address3 = "bss.order.Consumer.pinpoint.workorderchanges.v1.queue";
        DivertConfiguration dc1 = new DivertConfiguration().setName("WorkOrderChangesCBMA-Divert").setRoutingName("WorkOrderChangesCBMA-Divert").setAddress("bss.order.workorderchanges.v1.topic").setForwardingAddress("bss.order.Consumer.cbma.workorderchanges.v1.queue").setExclusive(false).setRoutingType(ComponentConfigurationRoutingType.ANYCAST);
        DivertConfiguration dc2 = new DivertConfiguration().setName("WorkOrderChangesPinpoint-Divert").setRoutingName("WorkOrderChangesPinpoint-Divert").setAddress("bss.order.workorderchanges.v1.topic").setForwardingAddress("bss.order.Consumer.pinpoint.workorderchanges.v1.queue").setExclusive(false).setRoutingType(ComponentConfigurationRoutingType.ANYCAST);
        this.server.deployDivert(dc1);
        this.server.deployDivert(dc2);
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        Connection connection = factory.createConnection(null, null);
        Session session = connection.createSession(false, 1);
        Topic topicSource = session.createTopic("bss.order.workorderchanges.v1.topic");
        Queue queueTarget = session.createQueue("bss.order.Consumer.cbma.workorderchanges.v1.queue");
        Queue queueTarget2 = session.createQueue("bss.order.Consumer.pinpoint.workorderchanges.v1.queue");
        MessageProducer producer = session.createProducer((Destination)topicSource);
        TextMessage message = session.createTextMessage("Hello");
        message.setStringProperty("filename", "BILHANDLE");
        connection.start();
        String selector = "filename='BILHANDLE'";
        MessageConsumer consumer = session.createConsumer((Destination)queueTarget, selector);
        MessageConsumer consumer2 = session.createConsumer((Destination)queueTarget2, selector);
        producer.send((Message)message);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        TextMessage receivedMessage2 = (TextMessage)consumer2.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertNotNull((Object)receivedMessage2);
        connection.close();
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
    }
}

