/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQPMessageLoadBalancingTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testLoadBalanceAMQP() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.0", "queues.0", null, true, null, null, RoutingType.ANYCAST);
        this.createQueue(1, "queues.0", "queues.0", null, true, null, null, RoutingType.ANYCAST);
        this.waitForBindings(0, "queues.0", 1, 0, true);
        this.waitForBindings(1, "queues.0", 1, 0, true);
        this.waitForBindings(0, "queues.0", 1, 0, false);
        this.waitForBindings(1, "queues.0", 1, 0, false);
        int NUMBER_OF_MESSAGES = 100;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("queues.0"));
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage("hello " + i));
        }
        session.commit();
        connection.close();
        this.receiveOnBothNodes(100);
        ClientSession sessionProducer = this.sfs[0].createSession();
        ClientProducer producer2 = sessionProducer.createProducer("queues.0");
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = sessionProducer.createMessage((byte)7, true).putIntProperty("i", i);
            message.getBodyBuffer().writeString("hello!");
            producer2.send((org.apache.activemq.artemis.api.core.Message)message);
            message = sessionProducer.createMessage((byte)7, true);
            producer2.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        this.receiveOnBothNodes(200);
    }

    private void receiveOnBothNodes(int NUMBER_OF_MESSAGES) throws ActiveMQException {
        for (int x = 0; x <= 1; ++x) {
            ClientSession sessionX = this.sfs[x].createSession();
            ClientConsumer consumerX = sessionX.createConsumer("queues.0");
            sessionX.start();
            for (int i = 0; i < NUMBER_OF_MESSAGES / 2; ++i) {
                ClientMessage msg = consumerX.receive(5000L);
                Assert.assertNotNull((Object)msg);
                msg.acknowledge();
            }
            Assert.assertNull((Object)consumerX.receiveImmediate());
            sessionX.commit();
            sessionX.close();
        }
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }
}

