/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.RedeployTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.Assert;
import org.junit.Test;

public class RedeployTempTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressQueueOpenWire() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("RedeployTempTest-reload-temp.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("RedeployTempTest-reload-temp-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue destination = session.createQueue("queue");
        MessageProducer messageProducer = session.createProducer((Destination)destination);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        TextMessage message = session.createTextMessage("hello");
        message.setJMSReplyTo((Destination)replyTo);
        messageProducer.send((Message)message);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            try (Connection connectionConsumer = connectionFactory.createConnection();){
                connectionConsumer.start();
                try (Session sessionConsumer = connection.createSession(false, 1);){
                    jakarta.jms.Queue destinationConsumer = session.createQueue("queue");
                    MessageConsumer messageConsumer = sessionConsumer.createConsumer((Destination)destinationConsumer);
                    Message receivedMessage = messageConsumer.receive(1000L);
                    RedeployTempTest.assertEquals((Object)"hello", (Object)((TextMessage)receivedMessage).getText());
                    Destination replyToDest = receivedMessage.getJMSReplyTo();
                    TextMessage message1 = sessionConsumer.createTextMessage("hi there");
                    session.createProducer(replyToDest).send((Message)message1);
                }
            }
            MessageConsumer messageConsumerProducer = session.createConsumer((Destination)replyTo);
            Message message2 = messageConsumerProducer.receive(1000L);
            Assert.assertNotNull((Object)message2);
            RedeployTempTest.assertEquals((Object)"hi there", (Object)((TextMessage)message2).getText());
        }
        finally {
            connection.close();
            embeddedActiveMQ.stop();
        }
    }

    private AddressSettings getAddressSettings(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch(address);
    }

    private Set<Role> getSecurityRoles(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch(address);
    }

    private AddressInfo getAddressInfo(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)address));
    }

    private Queue getQueue(EmbeddedActiveMQ embeddedActiveMQ, String queueName) throws Exception {
        QueueBinding queueBinding = (QueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName));
        return queueBinding == null ? null : queueBinding.getQueue();
    }

    private List<String> listQueuesNamesForAddress(EmbeddedActiveMQ embeddedActiveMQ, String address) throws Exception {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().listQueuesForAddress(SimpleString.toSimpleString((String)address)).stream().map(Queue::getName).map(SimpleString::toString).collect(Collectors.toList());
    }
}

