/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer12Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)2});
    }

    public JMSConsumer12Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testDontStart() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 1);
        JMSConsumer12Test.assertNull((Object)consumer.receive(1000L));
    }

    @Test
    public void testStartAfterSend() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 1);
        this.connection.start();
        JMSConsumer12Test.assertNotNull((Object)consumer.receive(1000L));
        JMSConsumer12Test.assertNull((Object)consumer.receiveNoWait());
    }
}

