/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer1Test
extends BasicOpenWireTest {
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public int ackMode;
    public byte destinationType;
    public boolean durableConsumer;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)2}, {1, (byte)5}, {1, (byte)6}, {2, (byte)1}, {2, (byte)2}, {2, (byte)5}, {2, (byte)6});
    }

    public JMSConsumer1Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testMessageListenerWithConsumerCanBeStopped() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done1 = new CountDownLatch(1);
        final CountDownLatch done2 = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 1) {
                    done1.countDown();
                }
                if (counter.get() == 2) {
                    done2.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)this.destination, 1);
        JMSConsumer1Test.assertTrue((boolean)done1.await(1L, TimeUnit.SECONDS));
        JMSConsumer1Test.assertEquals((long)1L, (long)counter.get());
        consumer.stop();
        this.sendMessages(session, (Destination)this.destination, 1);
        JMSConsumer1Test.assertFalse((boolean)done2.await(1L, TimeUnit.SECONDS));
        JMSConsumer1Test.assertEquals((long)1L, (long)counter.get());
        consumer.start();
        JMSConsumer1Test.assertTrue((boolean)done2.await(1L, TimeUnit.SECONDS));
        JMSConsumer1Test.assertEquals((long)2L, (long)counter.get());
    }
}

