/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.paging.PagingTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GlobalPagingTest
extends PagingTest {
    public GlobalPagingTest(StoreConfiguration.StoreType storeType, boolean mapped) {
        super(storeType, mapped);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings) {
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)realFiles));
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        server.getConfiguration().setGlobalMaxSize(maxAddressSize);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(pageSize).setMaxSizeBytes(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    @Override
    @Test
    @Ignore
    public void testPurge() throws Exception {
    }

    @Test
    public void testPagingOverFullDisk() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            return;
        }
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.getConfiguration().setGlobalMaxSize(-1L);
        this.server.start();
        ActiveMQServerImpl serverImpl = (ActiveMQServerImpl)this.server;
        serverImpl.getMonitor().stop();
        serverImpl.getMonitor().tick();
        int numberOfMessages = 500;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        final ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(PagingTest.ADDRESS));
        final ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        Object message = null;
        final byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(GlobalPagingTest.getSamplebyte((long)j));
        }
        Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().getPagingStore().forceAnotherPage();
        this.sendFewMessages(500, session, producer, body);
        serverImpl.getMonitor().setMaxUsage(0.0);
        serverImpl.getMonitor().tick();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    GlobalPagingTest.this.sendFewMessages(500, session, producer, body);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        t.join(1000L);
        Assert.assertTrue((boolean)t.isAlive());
        serverImpl.getMonitor().setMaxUsage(1.0).tick();
        t.join(5000L);
        Assert.assertFalse((boolean)t.isAlive());
        session.start();
        Wait.assertEquals((long)1000L, () -> ((Queue)queue).getMessageCount());
        ClientConsumer consumer = session.createConsumer(PagingTest.ADDRESS);
        ClientMessage msg = null;
        for (int i = 0; i < 1000; ++i) {
            msg = consumer.receive(1000L);
            GlobalPagingTest.assertNotNull((Object)msg);
            msg.acknowledge();
            if (i % 500 != 0) continue;
            session.commit();
        }
        session.commit();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    protected void sendFewMessages(int numberOfMessages, ClientSession session, ClientProducer producer, byte[] body) throws ActiveMQException {
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementAddressCannotPageOrChangeGlobalSize() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, -1L);
        try {
            SimpleString managementAddress = server.getConfiguration().getManagementAddress();
            server.getConfiguration().setGlobalMaxSize(1L);
            server.start();
            ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            try (ClientSessionFactory sf = this.createSessionFactory(locator);
                 ClientSession session = sf.createSession(false, true, true);){
                session.start();
                if (server.locateQueue(managementAddress) == null) {
                    session.createQueue(new QueueConfiguration(managementAddress));
                }
                Queue managementQueue = server.locateQueue(managementAddress);
                Assert.assertNull((Object)managementQueue.getPageSubscription());
                Assert.assertNull((Object)server.getPagingManager().getPageStore(managementAddress));
                SimpleString address = SimpleString.toSimpleString((String)"queue");
                if (server.locateQueue(address) == null) {
                    session.createQueue(new QueueConfiguration(address));
                }
                CountDownLatch startSendMessages = new CountDownLatch(1);
                PagingManager pagingManager = server.getPagingManager();
                long globalSize = pagingManager.getGlobalSize();
                Thread globalSizeChecker = new Thread(() -> {
                    startSendMessages.countDown();
                    while (!Thread.currentThread().isInterrupted()) {
                        Assert.assertEquals((long)globalSize, (long)pagingManager.getGlobalSize());
                    }
                });
                globalSizeChecker.start();
                try (ClientRequestor requestor = new ClientRequestor(session, managementAddress);){
                    ClientMessage message = session.createMessage(false);
                    ManagementHelper.putAttribute((ICoreMessage)message, (String)("queue." + address.toString()), (String)"messageCount");
                    Assert.assertTrue((String)("bodySize = " + message.getBodySize() + " must be > of globalMaxSize = " + server.getConfiguration().getGlobalMaxSize()), ((long)message.getBodySize() > server.getConfiguration().getGlobalMaxSize() ? (byte)1 : 0) != 0);
                    startSendMessages.await();
                    for (int i = 0; i < 100; ++i) {
                        try {
                            ClientMessage reply = requestor.request(message);
                            Assert.assertEquals((Object)0L, (Object)ManagementHelper.getResult((ICoreMessage)reply));
                            continue;
                        }
                        catch (ActiveMQAddressFullException e) {
                            Assert.fail((String)e.getMessage());
                            if (requestor != null) {
                                if (var17_20 != null) {
                                    try {
                                        requestor.close();
                                    }
                                    catch (Throwable throwable) {
                                        var17_20.addSuppressed(throwable);
                                    }
                                } else {
                                    requestor.close();
                                }
                            }
                            globalSizeChecker.interrupt();
                            if (session != null) {
                                if (var8_10 != null) {
                                    try {
                                        session.close();
                                    }
                                    catch (Throwable throwable) {
                                        var8_10.addSuppressed(throwable);
                                    }
                                } else {
                                    session.close();
                                }
                            }
                            if (sf != null) {
                                if (var6_6 != null) {
                                    try {
                                        sf.close();
                                    }
                                    catch (Throwable throwable) {
                                        var6_6.addSuppressed(throwable);
                                    }
                                } else {
                                    sf.close();
                                }
                            }
                            server.stop(true);
                            return;
                        }
                    }
                }
                finally {
                    globalSizeChecker.interrupt();
                }
            }
        }
        finally {
            server.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementMessageRequestCannotFailAfterFailedDirectDeliver() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultNettyConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, -1L);
        try {
            SimpleString managementAddress = server.getConfiguration().getManagementAddress();
            server.start();
            ServerLocator locator = this.createNettyNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            try (ClientSessionFactory sf = this.createSessionFactory(locator);
                 ClientSession session = sf.createSession(false, true, true);){
                SimpleString address;
                session.start();
                if (server.locateQueue(managementAddress) == null) {
                    session.createQueue(new QueueConfiguration(managementAddress));
                }
                if (server.locateQueue(address = SimpleString.toSimpleString((String)"queue")) == null) {
                    session.createQueue(new QueueConfiguration(address));
                }
                try (ClientProducer requestProducer = session.createProducer(managementAddress);){
                    SimpleString replyQueue = new SimpleString(managementAddress + "." + UUID.randomUUID().toString());
                    session.createQueue(new QueueConfiguration(replyQueue).setRoutingType(ActiveMQDefaultConfiguration.getDefaultRoutingType()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
                    int id = 1000;
                    try (ClientConsumer consumer = session.createConsumer(replyQueue);){
                        Queue queue = server.locateQueue(replyQueue);
                        MessageReference reference = MessageReference.Factory.createReference((Message)session.createMessage(false), (Queue)queue);
                        reference.getMessage().setMessageID((long)id++);
                        queue.addHead(reference, false);
                        Wait.assertFalse(() -> ((Queue)queue).isDirectDeliver());
                        queue.removeReferenceWithID(reference.getMessageID());
                        ClientMessage message = session.createMessage(false);
                        message.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, replyQueue);
                        ManagementHelper.putAttribute((ICoreMessage)message, (String)("queue." + address.toString()), (String)"messageCount");
                        requestProducer.send((Message)message);
                        Assert.assertNotNull((Object)consumer.receive());
                    }
                }
            }
        }
        finally {
            server.stop(true);
        }
    }
}

