/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.server.config.impl.TransportConfigurationEncodingSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class TransportConfigurationEncodingSupportTest
extends Assert {
    @Test
    public void testTransportConfiguration() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", 5665);
        params.put("host", RandomUtil.randomString());
        TransportConfiguration config = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)TransportConfigurationEncodingSupport.getEncodeSize((TransportConfiguration)config));
        TransportConfigurationEncodingSupport.encode((ActiveMQBuffer)buffer, (TransportConfiguration)config);
        TransportConfigurationEncodingSupportTest.assertEquals((long)buffer.capacity(), (long)buffer.writerIndex());
        buffer.readerIndex(0);
        TransportConfiguration decoded = TransportConfigurationEncodingSupport.decode((ActiveMQBuffer)buffer);
        TransportConfigurationEncodingSupportTest.assertNotNull((Object)decoded);
        TransportConfigurationEncodingSupportTest.assertEquals((Object)config.getName(), (Object)decoded.getName());
        TransportConfigurationEncodingSupportTest.assertEquals((Object)config.getFactoryClassName(), (Object)decoded.getFactoryClassName());
        TransportConfigurationEncodingSupportTest.assertEquals((long)config.getParams().size(), (long)decoded.getParams().size());
        for (String key : config.getParams().keySet()) {
            TransportConfigurationEncodingSupportTest.assertEquals((Object)config.getParams().get(key).toString(), (Object)decoded.getParams().get(key).toString());
        }
    }

    @Test
    public void testTransportConfigurations() throws Exception {
        ArrayList<Pair> connectorConfigs = new ArrayList<Pair>();
        HashMap<String, Integer> liveParams = new HashMap<String, Integer>();
        liveParams.put("port", 5665);
        TransportConfiguration live1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), liveParams);
        HashMap<String, Integer> backupParams = new HashMap<String, Integer>();
        backupParams.put("port", 5775);
        TransportConfiguration backup1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), backupParams);
        HashMap<String, Integer> liveParams2 = new HashMap<String, Integer>();
        liveParams2.put("port", 6665);
        TransportConfiguration live2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), liveParams2);
        connectorConfigs.add(new Pair((Object)live1, (Object)backup1));
        connectorConfigs.add(new Pair((Object)live2, null));
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)TransportConfigurationEncodingSupport.getEncodeSize(connectorConfigs));
        TransportConfigurationEncodingSupport.encodeConfigs((ActiveMQBuffer)buffer, connectorConfigs);
        TransportConfigurationEncodingSupportTest.assertEquals((long)buffer.capacity(), (long)buffer.writerIndex());
        buffer.readerIndex(0);
        List decodedConfigs = TransportConfigurationEncodingSupport.decodeConfigs((ActiveMQBuffer)buffer);
        TransportConfigurationEncodingSupportTest.assertNotNull((Object)decodedConfigs);
        TransportConfigurationEncodingSupportTest.assertEquals((long)2L, (long)decodedConfigs.size());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(0)).getA(), (TransportConfiguration)((Pair)decodedConfigs.get(0)).getA());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(0)).getB(), (TransportConfiguration)((Pair)decodedConfigs.get(0)).getB());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(1)).getA(), (TransportConfiguration)((Pair)decodedConfigs.get(1)).getA());
        TransportConfigurationEncodingSupportTest.assertNull((Object)((Pair)decodedConfigs.get(1)).getB());
    }

    private static void assertEquivalent(TransportConfiguration expected, TransportConfiguration actual) {
        TransportConfigurationEncodingSupportTest.assertEquals((Object)expected.getFactoryClassName(), (Object)actual.getFactoryClassName());
        TransportConfigurationEncodingSupportTest.assertEquals((Object)expected.getName(), (Object)actual.getName());
        TransportConfigurationEncodingSupportTest.assertEquals((long)expected.getParams().size(), (long)actual.getParams().size());
        for (Map.Entry entry : expected.getParams().entrySet()) {
            String key = (String)entry.getKey();
            TransportConfigurationEncodingSupportTest.assertEquals((Object)expected.getParams().get(key).toString(), (Object)actual.getParams().get(key).toString());
        }
    }
}

