/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.junit.Assert;
import org.junit.Test;

public class MqttPluginTest
extends MQTTTestSupport {
    private final Map<String, AtomicInteger> methodCalls = new ConcurrentHashMap<String, AtomicInteger>();
    private final MethodCalledVerifier verifier = new MethodCalledVerifier(this.methodCalls);

    @Override
    public void configureBroker() throws Exception {
        super.configureBroker();
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this.verifier);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveMQTT() throws Exception {
        final MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        final CountDownLatch latch = new CountDownLatch(250);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 250; ++i) {
                    try {
                        byte[] payload = subscriptionProvider.receive(10000);
                        Assert.assertNotNull((String)"Should get a message", (Object)payload);
                        latch.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        latch.await(10L, TimeUnit.SECONDS);
        MqttPluginTest.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
        this.verifier.validatePluginMethodsEquals(0, "messageExpired", "beforeDeployBridge", "afterDeployBridge");
        this.verifier.validatePluginMethodsAtLeast(1, "afterCreateConnection", "afterDestroyConnection", "beforeCreateSession", "afterCreateSession", "beforeCloseSession", "afterCloseSession", "beforeCreateConsumer", "afterCreateConsumer", "beforeCloseConsumer", "afterCloseConsumer", "beforeCreateQueue", "afterCreateQueue", "messageAcknowledged", "beforeSend", "afterSend", "beforeMessageRoute", "afterMessageRoute", "beforeDeliver", "afterDeliver", "beforeAddAddress", "afterAddAddress", "beforeAddBinding", "afterAddBinding", "beforeRemoveBinding", "afterRemoveBinding");
    }

    @Test(timeout=60000L)
    public void testMQTTAutoCreate() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        subscriptionProvider.disconnect();
        this.verifier.validatePluginMethodsAtLeast(1, "beforeAddAddress", "afterAddAddress", "beforeRemoveAddress", "afterRemoveAddress");
    }
}

