/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.impl.LegacyLDAPSecuritySettingPlugin;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"AMQauth.ldif"})
public class LegacyLDAPSecuritySettingPluginListenerTest
extends AbstractLdapTestUnit {
    private ServerLocator locator;
    ActiveMQServer server;
    public static final String TARGET_TMP = "./target/tmp";
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    @Rule
    public TemporaryFolder temporaryFolder;
    private String testDir;

    public LegacyLDAPSecuritySettingPluginListenerTest() {
        File parent = new File(TARGET_TMP);
        parent.mkdirs();
        this.temporaryFolder = new TemporaryFolder(parent);
    }

    @Before
    public void setUp() throws Exception {
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getCanonicalName())});
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
        LegacyLDAPSecuritySettingPlugin legacyLDAPSecuritySettingPlugin = new LegacyLDAPSecuritySettingPlugin();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("initialContextFactory", "com.sun.jndi.ldap.LdapCtxFactory");
        map.put("connectionURL", "ldap://localhost:1024");
        map.put("connectionUsername", PRINCIPAL);
        map.put("connectionPassword", CREDENTIALS);
        map.put("connectionProtocol", "s");
        map.put("authentication", "simple");
        map.put("enableListener", "true");
        legacyLDAPSecuritySettingPlugin.init(map);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("LDAPLogin");
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(true).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getCanonicalName())).setJournalDirectory(ActiveMQTestBase.getJournalDir((String)this.testDir, (int)0, (boolean)false)).setBindingsDirectory(ActiveMQTestBase.getBindingsDir((String)this.testDir, (int)0, (boolean)false)).setPagingDirectory(ActiveMQTestBase.getPageDir((String)this.testDir, (int)0, (boolean)false)).setLargeMessagesDirectory(ActiveMQTestBase.getLargeMessagesDir((String)this.testDir, (int)0, (boolean)false)).setPersistenceEnabled(false).addSecuritySettingPlugin((SecuritySettingPlugin)legacyLDAPSecuritySettingPlugin);
        this.server = ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        this.locator.close();
        this.server.stop();
    }

    @Test
    public void testRunning() throws Exception {
        DirContext ctx = this.getContext();
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
    }

    private DirContext getContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        return new InitialDirContext(env);
    }

    @Test
    public void testProducerPermissionUpdate() throws Exception {
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        String name = "queue1";
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        ClientSession session2 = cf.createSession("second", CREDENTIALS, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(name));
        ClientProducer producer = session.createProducer();
        ClientProducer producer2 = session2.createProducer();
        producer.send(name, (Message)session.createMessage(true));
        try {
            producer2.send(name, (Message)session.createMessage(true));
            Assert.fail((String)"Sending here should fail due to the original security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=role2");
        ctx.modifyAttributes("cn=write,cn=queue1,ou=queues,ou=destinations,o=ActiveMQ,ou=system", 2, (Attributes)basicAttributes);
        ctx.close();
        Wait.assertTrue(() -> {
            try {
                producer2.send(name, (Message)session.createMessage(true));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)100L);
        try {
            producer.send(name, (Message)session.createMessage(true));
            Assert.fail((String)"Sending here should fail due to the modified security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        cf.close();
    }

    @Test
    public void testConsumerPermissionUpdate() throws Exception {
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        String queue = "queue1";
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        ClientSession session2 = cf.createSession("second", CREDENTIALS, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(queue));
        ClientConsumer consumer = session.createConsumer(queue);
        consumer.receiveImmediate();
        consumer.close();
        try {
            session2.createConsumer(queue);
            Assert.fail((String)"Consuming here should fail due to the original security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=role2");
        ctx.modifyAttributes("cn=read,cn=queue1,ou=queues,ou=destinations,o=ActiveMQ,ou=system", 2, (Attributes)basicAttributes);
        ctx.close();
        Wait.assertTrue(() -> {
            try {
                ClientConsumer consumer2 = session2.createConsumer(queue);
                consumer2.receiveImmediate();
                consumer2.close();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)100L);
        try {
            session.createConsumer(queue);
            Assert.fail((String)"Sending here should fail due to the modified security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        cf.close();
    }

    @Test
    public void testNewConsumerPermission() throws Exception {
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        String queue = "queue2";
        this.server.createQueue(new QueueConfiguration(queue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.locator.createSessionFactory();
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        try {
            session.createConsumer(queue);
            Assert.fail((String)"Consuming here should fail due to the original security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=role1");
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("groupOfUniqueNames");
        basicAttributes.put(objclass);
        ctx.bind("cn=read,cn=" + queue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system", null, (Attributes)basicAttributes);
        Wait.assertTrue(() -> {
            try {
                ClientConsumer consumer = session.createConsumer(queue);
                consumer.receiveImmediate();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)100L);
        ctx.unbind("cn=read,cn=" + queue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system");
        ctx.close();
        try {
            session.createConsumer(queue);
            Assert.fail((String)"Consuming here should fail due to the modified security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        cf.close();
    }

    @Test
    public void testNewProducerPermission() throws Exception {
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        String queue = "queue2";
        this.server.createQueue(new QueueConfiguration(queue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.locator.createSessionFactory();
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        ClientProducer producer = session.createProducer(SimpleString.toSimpleString((String)queue));
        try {
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"Producing here should fail due to the original security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=role1");
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("groupOfUniqueNames");
        basicAttributes.put(objclass);
        ctx.bind("cn=write,cn=" + queue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system", null, (Attributes)basicAttributes);
        Wait.assertTrue(() -> {
            try {
                producer.send((Message)session.createMessage(true));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)100L);
        ctx.unbind("cn=write,cn=" + queue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system");
        ctx.close();
        try {
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"Producing here should fail due to the modified security data.");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        cf.close();
    }

    @Test
    public void testNewUserAndRole() throws Exception {
        ClientProducer producer;
        ClientSession session;
        String USERNAME = UUID.randomUUID().toString();
        String ROLE = UUID.randomUUID().toString();
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        String queue = "queue1";
        this.server.createQueue(new QueueConfiguration(queue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.locator.createSessionFactory();
        try {
            cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
            Assert.fail((String)"Creating a session here should fail due to the original security data.");
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("229031"));
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("userPassword", CREDENTIALS);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("simpleSecurityObject");
        objclass.add("account");
        basicAttributes.put(objclass);
        ctx.bind("uid=" + USERNAME + ",ou=system", null, (Attributes)basicAttributes);
        ctx = this.getContext();
        basicAttributes = new BasicAttributes();
        basicAttributes.put("member", "uid=" + USERNAME + ",ou=system");
        objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("groupOfNames");
        basicAttributes.put(objclass);
        ctx.bind("cn=" + ROLE + ",ou=system", null, (Attributes)basicAttributes);
        try {
            session = cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
            producer = session.createProducer(queue);
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"Producing here should fail due to the original security data.");
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("229032"));
        }
        ctx = this.getContext();
        basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=" + ROLE);
        ctx.modifyAttributes("cn=write,cn=queue1,ou=queues,ou=destinations,o=ActiveMQ,ou=system", 1, (Attributes)basicAttributes);
        ctx.close();
        session = cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
        producer = session.createProducer(queue);
        producer.send((Message)session.createMessage(true));
        cf.close();
    }

    @Test
    public void testNewUserAndRoleWithNewDestination() throws Exception {
        ClientProducer producer;
        ClientSession session;
        String USERNAME = UUID.randomUUID().toString();
        String ROLE = UUID.randomUUID().toString();
        this.server.getConfiguration().setSecurityInvalidationInterval(0L);
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        String goodQueue = "queue3";
        String badQueue = "queue4";
        try {
            cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
            Assert.fail((String)"Creating a session here should fail due to the original security data.");
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("229031"));
        }
        DirContext ctx = this.getContext();
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("userPassword", CREDENTIALS);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("simpleSecurityObject");
        objclass.add("account");
        basicAttributes.put(objclass);
        ctx.bind("uid=" + USERNAME + ",ou=system", null, (Attributes)basicAttributes);
        ctx = this.getContext();
        basicAttributes = new BasicAttributes();
        basicAttributes.put("member", "uid=" + USERNAME + ",ou=system");
        objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("groupOfNames");
        basicAttributes.put(objclass);
        ctx.bind("cn=" + ROLE + ",ou=system", null, (Attributes)basicAttributes);
        try {
            session = cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
            producer = session.createProducer(goodQueue);
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"Producing here should fail due to the original security data.");
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("229032"));
        }
        ctx = this.getContext();
        basicAttributes = new BasicAttributes();
        objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("applicationProcess");
        basicAttributes.put(objclass);
        ctx.bind("cn=" + goodQueue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system", null, (Attributes)basicAttributes);
        ctx = this.getContext();
        basicAttributes = new BasicAttributes();
        basicAttributes.put("uniquemember", "cn=" + ROLE);
        objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("groupOfUniqueNames");
        basicAttributes.put(objclass);
        ctx.bind("cn=write,cn=" + goodQueue + ",ou=queues,ou=destinations,o=ActiveMQ,ou=system", null, (Attributes)basicAttributes);
        this.server.createQueue(new QueueConfiguration(goodQueue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        session = cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
        producer = session.createProducer(goodQueue);
        producer.send((Message)session.createMessage(true));
        session.close();
        producer.close();
        this.server.createQueue(new QueueConfiguration(badQueue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        try {
            session = cf.createSession(USERNAME, CREDENTIALS, false, true, true, false, 0);
            producer = session.createProducer(badQueue);
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"Producing here should fail.");
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("229032"));
        }
        cf.close();
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = LegacyLDAPSecuritySettingPluginListenerTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

