/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.persistence.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public class OperationContextUnitTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteTaskAfterPaging() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        try {
            int i;
            OperationContextImpl impl = new OperationContextImpl((Executor)executor);
            final CountDownLatch latch1 = new CountDownLatch(1);
            final CountDownLatch latch2 = new CountDownLatch(1);
            impl.executeOnCompletion(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    latch1.countDown();
                }
            });
            OperationContextUnitTest.assertTrue((boolean)latch1.await(10L, TimeUnit.SECONDS));
            for (i = 0; i < 10; ++i) {
                impl.storeLineUp();
            }
            for (i = 0; i < 3; ++i) {
                impl.pageSyncLineUp();
            }
            impl.executeOnCompletion(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    latch2.countDown();
                }
            });
            OperationContextUnitTest.assertFalse((boolean)latch2.await(1L, TimeUnit.MILLISECONDS));
            for (i = 0; i < 9; ++i) {
                impl.done();
            }
            for (i = 0; i < 2; ++i) {
                impl.pageSyncDone();
            }
            OperationContextUnitTest.assertFalse((boolean)latch2.await(1L, TimeUnit.MILLISECONDS));
            impl.done();
            impl.pageSyncDone();
            OperationContextUnitTest.assertTrue((boolean)latch2.await(10L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorNotLostOnPageSyncError() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ExecutorService pageSyncTimer = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        try {
            int numJobs = 10000;
            final CountDownLatch errorsOnLateRegister = new CountDownLatch(10000);
            for (int i = 0; i < 10000; ++i) {
                OperationContextImpl impl = new OperationContextImpl((Executor)executor);
                final CountDownLatch done = new CountDownLatch(1);
                class PageWriteErrorJob
                implements Runnable {
                    final OperationContextImpl operationContext;

                    PageWriteErrorJob(OperationContextImpl impl) {
                        impl.pageSyncLineUp();
                        this.operationContext = impl;
                    }

                    @Override
                    public void run() {
                        try {
                            this.operationContext.onError(10, "bla");
                        }
                        finally {
                            this.operationContext.pageSyncDone();
                        }
                    }
                }
                pageSyncTimer.execute(new PageWriteErrorJob(impl));
                impl.executeOnCompletion(new IOCallback(){

                    public void onError(int errorCode, String errorMessage) {
                        errorsOnLateRegister.countDown();
                        done.countDown();
                    }

                    public void done() {
                        done.countDown();
                    }
                });
                done.await();
            }
            OperationContextUnitTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisfied() throws Exception {
                    return errorsOnLateRegister.await(1L, TimeUnit.SECONDS);
                }
            }));
        }
        finally {
            executor.shutdown();
            pageSyncTimer.shutdown();
        }
    }

    @Test
    public void testCaptureExceptionOnExecutor() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        executor.shutdown();
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationContextImpl impl = new OperationContextImpl(executor){

            public void complete() {
                super.complete();
                latch.countDown();
            }
        };
        impl.storeLineUp();
        final AtomicInteger numberOfFailures = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    impl.waitCompletion(5000L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    numberOfFailures.incrementAndGet();
                }
            }
        };
        t.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        impl.done();
        t.join();
        Assert.assertEquals((long)1L, (long)numberOfFailures.get());
    }

    @Test
    public void testCaptureExceptionOnFailure() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationContextImpl context = new OperationContextImpl(executor){

            public void complete() {
                super.complete();
                latch.countDown();
            }
        };
        context.storeLineUp();
        final AtomicInteger failures = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    context.waitCompletion(5000L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    failures.incrementAndGet();
                }
            }
        };
        t.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        context.onError(ActiveMQExceptionType.UNSUPPORTED_PACKET.getCode(), "Poop happens!");
        t.join();
        Assert.assertEquals((long)1L, (long)failures.get());
        failures.set(0);
        final AtomicInteger operations = new AtomicInteger(0);
        context.executeOnCompletion(new IOCallback(){

            public void done() {
                operations.incrementAndGet();
            }

            public void onError(int errorCode, String errorMessage) {
                failures.incrementAndGet();
            }
        });
        Assert.assertEquals((long)1L, (long)failures.get());
        Assert.assertEquals((long)0L, (long)operations.get());
    }
}

