/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.descriptions;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

public class ChildResourceDescriptionResolver
implements ResourceDescriptionResolver {
    private final ResourceDescriptionResolver parent;
    private final String prefix;
    private final List<PathElement> paths;

    protected ChildResourceDescriptionResolver(ResourceDescriptionResolver parent, String prefix, List<PathElement> paths) {
        this.parent = parent;
        this.prefix = prefix;
        this.paths = paths;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.parent.getResourceBundle(locale);
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getResourceAttributeDescription(attributeName, locale, bundle);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, suffixes);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
    }

    public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationDescription(operationName, locale, bundle);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, new String[0]))) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationParameterDescription(operationName, paramName, locale, bundle);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, suffixes))) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
    }

    public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, new String[]{operationName, "reply"}, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationReplyDescription(operationName, locale, bundle);
    }

    public String getOperationReplyValueTypeDescription(String operationName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, new String[]{operationName, "reply"}, suffixes);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationReplyValueTypeDescription(operationName, locale, bundle, suffixes);
    }

    public String getNotificationDescription(String notificationType, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, notificationType, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getNotificationDescription(notificationType, locale, bundle);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, childType, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getChildTypeDescription(childType, locale, bundle);
    }

    public String getResourceDescription(Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getResourceDescription(locale, bundle);
    }

    public String getResourceDeprecatedDescription(Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, "deprecated", new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getResourceDeprecatedDescription(locale, bundle);
    }

    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, "deprecated");
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
    }

    public String getOperationDeprecatedDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, "deprecated");
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationDeprecatedDescription(operationName, locale, bundle);
    }

    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, "deprecated"))) continue;
            return bundle.getString(key);
        }
        return this.parent.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
    }

    private String getBundleKey(PathElement path) {
        return this.getBundleKey(path, new String[0], new String[0]);
    }

    private String getBundleKey(PathElement path, String key, String ... suffixes) {
        return this.getBundleKey(path, new String[]{key}, suffixes);
    }

    private String getBundleKey(PathElement path, String[] keys, String ... suffixes) {
        String[] stringArray;
        StringBuilder builder = new StringBuilder(this.prefix);
        if (path.isWildcard()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path.getKey();
        } else {
            stringArray = path.getKeyValuePair();
        }
        for (String value : stringArray) {
            builder.append('.').append(value);
        }
        for (String key : keys) {
            builder.append('.').append(key);
        }
        for (String suffix : suffixes) {
            builder.append('.').append(suffix);
        }
        return builder.toString();
    }
}

