/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import jakarta.ws.rs.ApplicationPath;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class EmbeddedServerHelper {
    public void checkDeployment(ResteasyDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("A ResteasyDeployment object required");
        }
        if (deployment.getRegistry() == null) {
            deployment.start();
        }
    }

    public String checkAppDeployment(ResteasyDeployment deployment) {
        ApplicationPath appPath = null;
        if (deployment.getApplicationClass() != null) {
            try {
                Class<?> clazz = Class.forName(deployment.getApplicationClass());
                appPath = clazz.getAnnotation(ApplicationPath.class);
            }
            catch (ClassNotFoundException clazz) {}
        } else if (deployment.getApplication() != null) {
            appPath = deployment.getApplication().getClass().getAnnotation(ApplicationPath.class);
        }
        String aPath = null;
        if (appPath != null) {
            aPath = appPath.value();
        }
        return aPath;
    }

    public String checkAppPath(ApplicationPath appPath) {
        if (appPath != null) {
            return appPath.value();
        }
        return "/";
    }

    public String checkContextPath(String contextPath) {
        if (contextPath == null) {
            return "/";
        }
        if (!contextPath.startsWith("/")) {
            return "/" + contextPath;
        }
        return contextPath;
    }
}

