/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

public class AclConfigParser
implements XMLStreamConstants {
    public Set<ACLProviderEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        LinkedHashSet<ACLProviderEntry> entries = new LinkedHashSet<ACLProviderEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            ACLProviderEntry entry = null;
            if (!"acl-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private ACLProviderEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag controlFlag = ControlFlag.REQUIRED;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = ControlFlag.valueOf(attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        ACLProviderEntry entry = new ACLProviderEntry(codeName, options);
        entry.setControlFlag(controlFlag);
        return entry;
    }

    public Set<ACLProviderEntry> parse(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashSet<ACLProviderEntry> entries = new LinkedHashSet<ACLProviderEntry>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            ACLProviderEntry entry = null;
            if (element.equals((Object)Element.ACL_MODULE)) {
                entry = this.getEntry(reader);
                entries.add(entry);
                continue;
            }
            StaxParserUtil.unexpectedElement(reader);
        }
        return entries;
    }

    private ACLProviderEntry getEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag controlFlag = ControlFlag.REQUIRED;
        int count = reader.getAttributeCount();
        if (count < 2) {
            HashSet<Attribute> set = new HashSet<Attribute>();
            set.add(Attribute.CODE);
            set.add(Attribute.FLAG);
            throw StaxParserUtil.missingRequired(reader, set);
        }
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    codeName = value;
                    continue block4;
                }
                case FLAG: {
                    controlFlag = ControlFlag.valueOf(value);
                    continue block4;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        ACLProviderEntry entry = new ACLProviderEntry(codeName, options);
        entry.setControlFlag(controlFlag);
        return entry;
    }
}

