/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.UUID;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.spi.persistence.DelimitedKeyFormat;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;

public class SessionAttributeKeyFormat
extends DelimitedKeyFormat<SessionAttributeKey> {
    public SessionAttributeKeyFormat() {
        super(SessionAttributeKey.class, "#", (Function)new SessionAttributeKeyParser(), (Function)new SessionAttributeKeyFormatter());
    }

    static class SessionAttributeKeyParser
    implements Function<String[], SessionAttributeKey> {
        SessionAttributeKeyParser() {
        }

        @Override
        public SessionAttributeKey apply(String[] parts) {
            return new SessionAttributeKey(parts[0], UUID.fromString(parts[1]));
        }
    }

    static class SessionAttributeKeyFormatter
    implements Function<SessionAttributeKey, String[]> {
        SessionAttributeKeyFormatter() {
        }

        @Override
        public String[] apply(SessionAttributeKey key) {
            return new String[]{(String)key.getId(), key.getAttributeId().toString()};
        }
    }
}

