/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.ChoiceChannelCredentials;
import io.grpc.CompositeCallCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.InsecureChannelCredentials;
import io.grpc.Internal;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AtomicBackoff;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportTracer;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.SslSocketFactoryChannelCredentials;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.CipherSuite;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.Platform;
import io.grpc.okhttp.internal.TlsVersion;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    @VisibleForTesting
    static final ConnectionSpec INTERNAL_DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384).tlsVersions(TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final SharedResourceHolder.Resource<Executor> SHARED_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

        public Executor create() {
            return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory((String)"grpc-okhttp-%d", (boolean)true));
        }

        public void close(Executor executor) {
            ((ExecutorService)executor).shutdown();
        }
    };
    private Executor transportExecutor;
    private ScheduledExecutorService scheduledExecutorService;
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private final boolean freezeSecurityConfiguration;
    private HostnameVerifier hostnameVerifier;
    private ConnectionSpec connectionSpec = INTERNAL_DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private int flowControlWindow = 65535;
    private boolean keepAliveWithoutCalls;
    private int maxInboundMessageSize = 0x400000;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private final boolean useGetForSafeMethods = false;
    private static final EnumSet<TlsChannelCredentials.Feature> understoodTlsFeatures = EnumSet.noneOf(TlsChannelCredentials.Feature.class);

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    public static OkHttpChannelBuilder forAddress(String host, int port, ChannelCredentials creds) {
        return OkHttpChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)host, (int)port), creds);
    }

    public static OkHttpChannelBuilder forTarget(String target) {
        return new OkHttpChannelBuilder(target);
    }

    public static OkHttpChannelBuilder forTarget(String target, ChannelCredentials creds) {
        SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new OkHttpChannelBuilder(target, creds, result.callCredentials, result.factory);
    }

    private OkHttpChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort((String)host, (int)port));
    }

    private OkHttpChannelBuilder(String target) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new OkHttpChannelTransportFactoryBuilder(), (ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider)new OkHttpChannelDefaultPortProvider());
        this.freezeSecurityConfiguration = false;
    }

    OkHttpChannelBuilder(String target, ChannelCredentials channelCreds, CallCredentials callCreds, SSLSocketFactory factory) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, channelCreds, callCreds, (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new OkHttpChannelTransportFactoryBuilder(), (ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider)new OkHttpChannelDefaultPortProvider());
        this.sslSocketFactory = factory;
        this.negotiationType = factory == null ? NegotiationType.PLAINTEXT : NegotiationType.TLS;
        this.freezeSecurityConfiguration = true;
    }

    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @VisibleForTesting
    OkHttpChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutor = transportExecutor;
        return this;
    }

    public OkHttpChannelBuilder socketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    @Deprecated
    public OkHttpChannelBuilder negotiationType(io.grpc.okhttp.NegotiationType type) {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type");
        switch (type) {
            case TLS: {
                this.negotiationType = NegotiationType.TLS;
                break;
            }
            case PLAINTEXT: {
                this.negotiationType = NegotiationType.PLAINTEXT;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown negotiation type: " + (Object)((Object)type)));
            }
        }
        return this;
    }

    public OkHttpChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (Object)"keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos((long)this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public OkHttpChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (Object)"keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos((long)this.keepAliveTimeoutNanos);
        return this;
    }

    public OkHttpChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public OkHttpChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        this.sslSocketFactory = factory;
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public OkHttpChannelBuilder hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public OkHttpChannelBuilder connectionSpec(com.squareup.okhttp.ConnectionSpec connectionSpec) {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        Preconditions.checkArgument((boolean)connectionSpec.isTls(), (Object)"plaintext ConnectionSpec is not accepted");
        this.connectionSpec = Utils.convertSpec(connectionSpec);
        return this;
    }

    public OkHttpChannelBuilder usePlaintext() {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        this.negotiationType = NegotiationType.PLAINTEXT;
        return this;
    }

    public OkHttpChannelBuilder useTransportSecurity() {
        Preconditions.checkState((!this.freezeSecurityConfiguration ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public OkHttpChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        return this;
    }

    public OkHttpChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public OkHttpChannelBuilder maxInboundMessageSize(int max) {
        Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"negative max");
        this.maxInboundMessageSize = max;
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        boolean enableKeepAlive = this.keepAliveTimeNanos != Long.MAX_VALUE;
        return new OkHttpTransportFactory(this.transportExecutor, this.scheduledExecutorService, this.socketFactory, this.createSslSocketFactory(), this.hostnameVerifier, this.connectionSpec, this.maxInboundMessageSize, enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory, false);
    }

    OkHttpChannelBuilder disableCheckAuthority() {
        this.managedChannelImplBuilder.disableCheckAuthority();
        return this;
    }

    OkHttpChannelBuilder enableCheckAuthority() {
        this.managedChannelImplBuilder.enableCheckAuthority();
        return this;
    }

    int getDefaultPort() {
        switch (this.negotiationType) {
            case PLAINTEXT: {
                return 80;
            }
            case TLS: {
                return 443;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    @Nullable
    @VisibleForTesting
    SSLSocketFactory createSslSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext sslContext = SSLContext.getInstance("Default", Platform.get().getProvider());
                        this.sslSocketFactory = sslContext.getSocketFactory();
                    }
                    return this.sslSocketFactory;
                }
                catch (GeneralSecurityException gse) {
                    throw new RuntimeException("TLS Provider failure", gse);
                }
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    static SslSocketFactoryResult sslSocketFactoryFrom(ChannelCredentials creds) {
        if (creds instanceof TlsChannelCredentials) {
            SSLSocketFactory sslSocketFactory;
            TlsChannelCredentials tlsCreds = (TlsChannelCredentials)creds;
            Set incomprehensible = tlsCreds.incomprehensible(understoodTlsFeatures);
            if (!incomprehensible.isEmpty()) {
                return SslSocketFactoryResult.error("TLS features not understood: " + incomprehensible);
            }
            try {
                SSLContext sslContext = SSLContext.getInstance("Default", Platform.get().getProvider());
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("TLS Provider failure", gse);
            }
            return SslSocketFactoryResult.factory(sslSocketFactory);
        }
        if (creds instanceof InsecureChannelCredentials) {
            return SslSocketFactoryResult.plaintext();
        }
        if (creds instanceof CompositeChannelCredentials) {
            CompositeChannelCredentials compCreds = (CompositeChannelCredentials)creds;
            return OkHttpChannelBuilder.sslSocketFactoryFrom(compCreds.getChannelCredentials()).withCallCredentials(compCreds.getCallCredentials());
        }
        if (creds instanceof SslSocketFactoryChannelCredentials.ChannelCredentials) {
            SslSocketFactoryChannelCredentials.ChannelCredentials factoryCreds = (SslSocketFactoryChannelCredentials.ChannelCredentials)creds;
            return SslSocketFactoryResult.factory(factoryCreds.getFactory());
        }
        if (creds instanceof ChoiceChannelCredentials) {
            ChoiceChannelCredentials choiceCreds = (ChoiceChannelCredentials)creds;
            StringBuilder error = new StringBuilder();
            for (ChannelCredentials innerCreds : choiceCreds.getCredentialsList()) {
                SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(innerCreds);
                if (result.error == null) {
                    return result;
                }
                error.append(", ");
                error.append(result.error);
            }
            return SslSocketFactoryResult.error(error.substring(2));
        }
        return SslSocketFactoryResult.error("Unsupported credential type: " + creds.getClass().getName());
    }

    @Internal
    static final class OkHttpTransportFactory
    implements ClientTransportFactory {
        private final Executor executor;
        private final boolean usingSharedExecutor;
        private final boolean usingSharedScheduler;
        private final TransportTracer.Factory transportTracerFactory;
        private final SocketFactory socketFactory;
        @Nullable
        private final SSLSocketFactory sslSocketFactory;
        @Nullable
        private final HostnameVerifier hostnameVerifier;
        private final ConnectionSpec connectionSpec;
        private final int maxMessageSize;
        private final boolean enableKeepAlive;
        private final long keepAliveTimeNanos;
        private final AtomicBackoff keepAliveBackoff;
        private final long keepAliveTimeoutNanos;
        private final int flowControlWindow;
        private final boolean keepAliveWithoutCalls;
        private final int maxInboundMetadataSize;
        private final ScheduledExecutorService timeoutService;
        private final boolean useGetForSafeMethods;
        private boolean closed;

        private OkHttpTransportFactory(Executor executor, @Nullable ScheduledExecutorService timeoutService, @Nullable SocketFactory socketFactory, @Nullable SSLSocketFactory sslSocketFactory, @Nullable HostnameVerifier hostnameVerifier, ConnectionSpec connectionSpec, int maxMessageSize, boolean enableKeepAlive, long keepAliveTimeNanos, long keepAliveTimeoutNanos, int flowControlWindow, boolean keepAliveWithoutCalls, int maxInboundMetadataSize, TransportTracer.Factory transportTracerFactory, boolean useGetForSafeMethods) {
            this.usingSharedScheduler = timeoutService == null;
            this.timeoutService = this.usingSharedScheduler ? (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE) : timeoutService;
            this.socketFactory = socketFactory;
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveTimeNanos = keepAliveTimeNanos;
            this.keepAliveBackoff = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.flowControlWindow = flowControlWindow;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.useGetForSafeMethods = useGetForSafeMethods;
            this.usingSharedExecutor = executor == null;
            this.transportTracerFactory = (TransportTracer.Factory)Preconditions.checkNotNull((Object)transportTracerFactory, (Object)"transportTracerFactory");
            this.executor = this.usingSharedExecutor ? (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)SHARED_EXECUTOR) : executor;
        }

        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveBackoff.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            OkHttpClientTransport transport = new OkHttpClientTransport(inetSocketAddr, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.executor, this.socketFactory, this.sslSocketFactory, this.hostnameVerifier, this.connectionSpec, this.maxMessageSize, this.flowControlWindow, options.getHttpConnectProxiedSocketAddress(), tooManyPingsRunnable, this.maxInboundMetadataSize, this.transportTracerFactory.create(), this.useGetForSafeMethods);
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            }
            return transport;
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timeoutService;
        }

        @Nullable
        @CheckReturnValue
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(channelCreds);
            if (result.error != null) {
                return null;
            }
            OkHttpTransportFactory factory = new OkHttpTransportFactory(this.executor, this.timeoutService, this.socketFactory, result.factory, this.hostnameVerifier, this.connectionSpec, this.maxMessageSize, this.enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory, this.useGetForSafeMethods);
            return new ClientTransportFactory.SwapChannelCredentialsResult((ClientTransportFactory)factory, result.callCredentials);
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedScheduler) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.timeoutService);
            }
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)SHARED_EXECUTOR, (Object)this.executor);
            }
        }
    }

    static final class SslSocketFactoryResult {
        public final SSLSocketFactory factory;
        public final CallCredentials callCredentials;
        public final String error;

        private SslSocketFactoryResult(SSLSocketFactory factory, CallCredentials creds, String error) {
            this.factory = factory;
            this.callCredentials = creds;
            this.error = error;
        }

        public static SslSocketFactoryResult error(String error) {
            return new SslSocketFactoryResult(null, null, (String)Preconditions.checkNotNull((Object)error, (Object)"error"));
        }

        public static SslSocketFactoryResult plaintext() {
            return new SslSocketFactoryResult(null, null, null);
        }

        public static SslSocketFactoryResult factory(SSLSocketFactory factory) {
            return new SslSocketFactoryResult((SSLSocketFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory"), null, null);
        }

        public SslSocketFactoryResult withCallCredentials(CallCredentials callCreds) {
            Preconditions.checkNotNull((Object)callCreds, (Object)"callCreds");
            if (this.error != null) {
                return this;
            }
            if (this.callCredentials != null) {
                callCreds = new CompositeCallCredentials(this.callCredentials, callCreds);
            }
            return new SslSocketFactoryResult(this.factory, callCreds, null);
        }
    }

    private final class OkHttpChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private OkHttpChannelDefaultPortProvider() {
        }

        public int getDefaultPort() {
            return OkHttpChannelBuilder.this.getDefaultPort();
        }
    }

    private final class OkHttpChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private OkHttpChannelTransportFactoryBuilder() {
        }

        public ClientTransportFactory buildClientTransportFactory() {
            return OkHttpChannelBuilder.this.buildTransportFactory();
        }
    }

    private static enum NegotiationType {
        TLS,
        PLAINTEXT;

    }
}

