/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.spi.OASFactoryResolverImpl;
import io.undertow.servlet.api.DeploymentInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.IndexView;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIDocumentBuilder;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIServiceNameProvider;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;

public class OpenAPIModelServiceConfigurator
extends SimpleServiceNameProvider
implements OpenAPIServiceNameProvider,
ServiceConfigurator,
Supplier<OpenAPI> {
    private static final String PATH = "mp.openapi.extensions.path";
    private static final String DEFAULT_PATH = "/openapi";
    private static final String RELATIVE_SERVER_URLS = "mp.openapi.extensions.servers.relative";
    private static final String DEFAULT_TITLE = "Generated API";
    private static final Set<String> REQUISITE_LISTENERS = Collections.singleton("http");
    private static final Map<Format, List<String>> STATIC_FILES = new EnumMap<Format, List<String>>(Format.class);
    private final Config config;
    private final String deploymentName;
    private final VirtualFile root;
    private final CompositeIndex index;
    private final Module module;
    private final JBossWebMetaData metaData;
    private final SupplierDependency<Host> host;
    private final SupplierDependency<DeploymentInfo> info;

    public OpenAPIModelServiceConfigurator(DeploymentUnit unit, String serverName, String hostName, Config config) {
        super(((CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityServiceName("org.wildfly.undertow.host", new String[]{serverName, hostName}).append(new String[]{config.getOptionalValue(PATH, String.class).orElse(DEFAULT_PATH)}));
        this.deploymentName = unit.getName();
        this.root = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        ArrayList indexes = new ArrayList(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
        if (unit.getParent() != null) {
            indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getParent().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
            ((AttachmentList)unit.getParent().getAttachment(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS)).forEach(subdeployment -> indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)subdeployment.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes()));
        }
        this.index = CompositeIndex.create((Collection)indexes.stream().map(IndexView.class::cast).collect(Collectors.toList()));
        this.module = (Module)unit.getAttachment(Attachments.MODULE);
        this.metaData = ((WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        this.config = config;
        this.host = new ServiceSupplierDependency(this.getHostServiceName());
        this.info = new ServiceSupplierDependency(UndertowService.deploymentServiceName((ServiceName)unit.getServiceName()).append(UndertowDeploymentInfoService.SERVICE_NAME));
        if (!this.getPath().equals(DEFAULT_PATH)) {
            MicroProfileOpenAPILogger.LOGGER.nonStandardEndpoint(unit.getName(), this.getPath(), DEFAULT_PATH);
        }
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer model = new CompositeDependency(new Dependency[]{this.host, this.info}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(model, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public OpenAPI get() {
        OpenApiConfigImpl config = new OpenApiConfigImpl(this.config);
        FilteredIndexView indexView = new FilteredIndexView((IndexView)this.index, (OpenApiConfig)config);
        OpenAPIDocumentBuilder builder = new OpenAPIDocumentBuilder();
        builder.config((OpenApiConfig)config);
        Map.Entry<VirtualFile, Format> entry = OpenAPIModelServiceConfigurator.findStaticFile(this.root);
        if (entry != null) {
            VirtualFile file = entry.getKey();
            Format format = entry.getValue();
            try (OpenApiStaticFile staticFile = new OpenApiStaticFile(file.openStream(), format);){
                builder.staticFileModel(OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
            }
            catch (IOException e) {
                throw MicroProfileOpenAPILogger.LOGGER.failedToLoadStaticFile(e, file.getPathNameRelativeTo(this.root), this.deploymentName);
            }
        }
        builder.annotationsModel(OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (ClassLoader)AnnotationScanner.class.getClassLoader(), (IndexView)indexView));
        builder.readerModel(OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)this.module.getClassLoader()));
        builder.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)this.module.getClassLoader()));
        OpenAPI model = builder.build();
        DescriptionGroupMetaData descriptionMetaData = this.metaData.getDescriptionGroup();
        String displayName = descriptionMetaData != null ? descriptionMetaData.getDisplayName() : null;
        String title = displayName != null ? displayName : this.deploymentName;
        String description = descriptionMetaData != null ? descriptionMetaData.getDescription() : null;
        Info info = model.getInfo();
        if (info.getTitle().equals(DEFAULT_TITLE)) {
            info.setTitle(title);
        }
        if (info.getDescription() == null) {
            info.setDescription(description);
        }
        Host host = (Host)this.host.get();
        List listeners = host.getServer().getListeners();
        if (model.getServers() == null) {
            String contextPath = ((DeploymentInfo)this.info.get()).getContextPath();
            if (this.config.getOptionalValue(RELATIVE_SERVER_URLS, Boolean.class).orElse(Boolean.TRUE).booleanValue()) {
                model.setServers(Collections.singletonList(OASFactory.createServer().url(contextPath)));
            } else {
                int aliases = host.getAllAliases().size();
                int size = 0;
                for (UndertowListener listener : listeners) {
                    size += aliases + listener.getSocketBinding().getClientMappings().size();
                }
                ArrayList<Server> servers = new ArrayList<Server>(size);
                for (UndertowListener listener : listeners) {
                    Server server;
                    SocketBinding binding = listener.getSocketBinding();
                    TreeSet<String> virtualHosts = new TreeSet<String>(host.getAllAliases());
                    virtualHosts.remove(host.getName());
                    InetAddress address = binding.getAddress();
                    if (!address.isAnyLocalAddress()) {
                        virtualHosts.add(address.getCanonicalHostName());
                    }
                    for (String virtualHost : virtualHosts) {
                        server = OpenAPIModelServiceConfigurator.createServer(listener.getProtocol(), virtualHost, binding.getPort(), contextPath);
                        if (server == null) continue;
                        servers.add(server);
                    }
                    for (ClientMapping mapping : binding.getClientMappings()) {
                        server = OpenAPIModelServiceConfigurator.createServer(listener.getProtocol(), mapping.getDestinationAddress(), mapping.getDestinationPort(), contextPath);
                        if (server == null) continue;
                        servers.add(server);
                    }
                }
                model.setServers(servers);
            }
        }
        if (listeners.stream().map(UndertowListener::getProtocol).noneMatch(REQUISITE_LISTENERS::contains)) {
            MicroProfileOpenAPILogger.LOGGER.requiredListenersNotFound(host.getServer().getName(), REQUISITE_LISTENERS);
        }
        return model;
    }

    private static Map.Entry<VirtualFile, Format> findStaticFile(VirtualFile root) {
        for (Format format : EnumSet.of(Format.YAML, Format.JSON)) {
            for (String resource : STATIC_FILES.get(format)) {
                VirtualFile file = root.getChild(resource);
                if (!file.exists()) continue;
                return new AbstractMap.SimpleImmutableEntry<VirtualFile, Format>(file, format);
            }
        }
        return null;
    }

    private static Server createServer(String protocol, String host, int port, String path) {
        try {
            URL url = new URL(protocol, host, port, path);
            if (port == url.getDefaultPort()) {
                url = new URL(protocol, host, path);
            }
            return OASFactory.createServer().url(url.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static {
        STATIC_FILES.put(Format.YAML, Arrays.asList("/META-INF/openapi.yaml", "/WEB-INF/classes/META-INF/openapi.yaml", "/META-INF/openapi.yml", "/WEB-INF/classes/META-INF/openapi.yml"));
        STATIC_FILES.put(Format.JSON, Arrays.asList("/META-INF/openapi.json", "/WEB-INF/classes/META-INF/openapi.json"));
        OASFactoryResolver.setInstance((OASFactoryResolver)new OASFactoryResolverImpl());
    }
}

