/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.at.remote;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wst.at.remote.ContextManager;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.processors.ParticipantProcessor;
import com.arjuna.wsc.CannotRegisterException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import com.arjuna.wsc11.RegistrationCoordinator;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.messaging.engines.ParticipantEngine;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;

public class TransactionManagerImple
extends TransactionManager {
    private ContextManager _ctxManager = new ContextManager();

    @Override
    public void enlistForDurableTwoPhase(Durable2PCParticipant tpp, String id) throws WrongStateException, UnknownTransactionException, SystemException {
        try {
            W3CEndpointReference participant = this.getParticipant(id, this.isCurrentContextSecure());
            W3CEndpointReference coordinator = this.registerParticipant(participant, "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC");
            ParticipantProcessor.getProcessor().activateParticipant(new ParticipantEngine(tpp, id, coordinator), id);
        }
        catch (InvalidProtocolException ex) {
            throw new SystemException(ex.toString());
        }
        catch (InvalidStateException ex) {
            throw new WrongStateException();
        }
        catch (CannotRegisterException ex) {
            throw new UnknownTransactionException();
        }
    }

    @Override
    public void enlistForVolatileTwoPhase(Volatile2PCParticipant tpp, String id) throws WrongStateException, UnknownTransactionException, SystemException {
        try {
            W3CEndpointReference participant = this.getParticipant(id, this.isCurrentContextSecure());
            W3CEndpointReference coordinator = this.registerParticipant(participant, "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Volatile2PC");
            ParticipantProcessor.getProcessor().activateParticipant(new ParticipantEngine(tpp, id, coordinator), id);
        }
        catch (InvalidProtocolException ex) {
            throw new SystemException(ex.toString());
        }
        catch (InvalidStateException ex) {
            throw new WrongStateException();
        }
        catch (CannotRegisterException ex) {
            ex.printStackTrace();
            throw new UnknownTransactionException();
        }
    }

    @Override
    public int replay() throws SystemException {
        throw new SystemException(wstxLogger.i18NLogger.get_mwlabs_wst_at_remote_Transaction11ManagerImple_1());
    }

    @Override
    public TxContext suspend() throws SystemException {
        return this._ctxManager.suspend();
    }

    @Override
    public void resume(TxContext tx) throws UnknownTransactionException, SystemException {
        this._ctxManager.resume(tx);
    }

    @Override
    public TxContext currentTransaction() throws SystemException {
        return this._ctxManager.currentTransaction();
    }

    private boolean isCurrentContextSecure() throws SystemException {
        TxContextImple currentTx = (TxContextImple)this._ctxManager.currentTransaction();
        if (currentTx != null) {
            return currentTx.isSecure();
        }
        return false;
    }

    final W3CEndpointReference getParticipant(String id, boolean isSecure) {
        QName serviceName = AtomicTransactionConstants.PARTICIPANT_SERVICE_QNAME;
        QName endpointName = AtomicTransactionConstants.PARTICIPANT_PORT_QNAME;
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String address = serviceRegistry.getServiceURI("ParticipantService", isSecure);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.serviceName(serviceName);
        builder.endpointName(endpointName);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier(builder, id);
        return builder.build();
    }

    final W3CEndpointReference registerParticipant(W3CEndpointReference participant, String protocol) throws InvalidProtocolException, InvalidStateException, CannotRegisterException, SystemException {
        TxContextImple currentTx = null;
        try {
            currentTx = (TxContextImple)this._ctxManager.suspend();
            if (currentTx == null) {
                throw new CannotRegisterException();
            }
            CoordinationContextType coordinationContext = currentTx.context().getCoordinationContext();
            String messageId = MessageId.getMessageId();
            W3CEndpointReference w3CEndpointReference = RegistrationCoordinator.register(coordinationContext, messageId, participant, protocol);
            return w3CEndpointReference;
        }
        catch (SoapFault sf) {
            throw new SystemException(sf.getMessage());
        }
        catch (CannotRegisterException cre) {
            throw cre;
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (InvalidProtocolException ipe) {
            throw ipe;
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
        finally {
            try {
                if (currentTx != null) {
                    this._ctxManager.resume(currentTx);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

