/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

class ELUtil {
    private static final String EL_BC22_PROPERTY = "org.wildfly.el.bc2.2";
    static final Properties properties = new Properties();
    private static ExpressionFactory exprFactory = null;
    private static ThreadLocal<Map<String, ResourceBundle>> instance;

    private ELUtil() {
    }

    private static void setupProperties() {
        boolean bc22Enabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(ELUtil.EL_BC22_PROPERTY);
            }
        });
        if (bc22Enabled) {
            properties.setProperty("jakarta.el.bc2.2", "true");
        }
    }

    private static Map<String, ResourceBundle> getCurrentInstance() {
        Map<String, ResourceBundle> result = instance.get();
        if (result == null) {
            result = new HashMap<String, ResourceBundle>();
            ELUtil.setCurrentInstance(result);
        }
        return result;
    }

    private static void setCurrentInstance(Map<String, ResourceBundle> context) {
        instance.set(context);
    }

    public static String getExceptionMessageString(ELContext context, String messageId) {
        return ELUtil.getExceptionMessageString(context, messageId, null);
    }

    public static String getExceptionMessageString(ELContext context, String messageId, Object[] params) {
        String result = "";
        Locale locale = null;
        if (null == context || null == messageId) {
            return result;
        }
        locale = context.getLocale();
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (locale != null) {
            Map<String, ResourceBundle> threadMap = ELUtil.getCurrentInstance();
            ResourceBundle resourceBundle = null;
            resourceBundle = threadMap.get(locale.toString());
            if (null == resourceBundle) {
                resourceBundle = ResourceBundle.getBundle("jakarta.el.PrivateMessages", locale);
                threadMap.put(locale.toString(), resourceBundle);
            }
            if (null != resourceBundle) {
                try {
                    result = resourceBundle.getString(messageId);
                    if (null != params) {
                        result = MessageFormat.format(result, params);
                    }
                }
                catch (IllegalArgumentException iae) {
                    result = "Can't get localized message: parameters to message appear to be incorrect.  Message to format: " + messageId;
                }
                catch (MissingResourceException mre) {
                    result = "Missing Resource in Jakarta Expression Language implementation: ???" + messageId + "???";
                }
                catch (Exception e) {
                    result = "Exception resolving message in Jakarta Expression Language implementation: ???" + messageId + "???";
                }
            }
        }
        return result;
    }

    static ExpressionFactory getExpressionFactory() {
        if (exprFactory == null) {
            exprFactory = ExpressionFactory.newInstance(properties);
        }
        return exprFactory;
    }

    static Constructor<?> findConstructor(Class<?> klass, Class<?>[] paramTypes, Object[] params) {
        Constructor<?>[] constructors;
        List<Wrapper> wrappers;
        Wrapper result;
        String methodName = "<init>";
        if (klass == null) {
            throw new MethodNotFoundException("Method not found: " + klass + "." + methodName + "(" + ELUtil.paramString(paramTypes) + ")");
        }
        if (paramTypes == null) {
            paramTypes = ELUtil.getTypesFromValues(params);
        }
        if ((result = ELUtil.findWrapper(klass, wrappers = Wrapper.wrap(constructors = klass.getConstructors()), methodName, paramTypes, params)) == null) {
            return null;
        }
        return ELUtil.getConstructor(klass, (Constructor)result.unWrap());
    }

    static Object invokeConstructor(ELContext context, Constructor<?> constructor, Object[] params) {
        Object[] parameters = ELUtil.buildParameters(context, constructor.getParameterTypes(), constructor.isVarArgs(), params);
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (InstantiationException ie) {
            throw new ELException(ie.getCause());
        }
    }

    static Method findMethod(Class<?> klass, String methodName, Class<?>[] paramTypes, Object[] params, boolean staticOnly) {
        Method method = ELUtil.findMethod(klass, methodName, paramTypes, params);
        if (staticOnly && !Modifier.isStatic(method.getModifiers())) {
            throw new MethodNotFoundException("Method " + methodName + "for class " + klass + " not found or accessible");
        }
        return method;
    }

    static Object invokeMethod(ELContext context, Method method, Object base, Object[] params) {
        Object[] parameters = ELUtil.buildParameters(context, method.getParameterTypes(), method.isVarArgs(), params);
        try {
            return method.invoke(base, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
    }

    static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        Method[] methods;
        List<Wrapper> wrappers;
        Wrapper result;
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException("Method not found: " + clazz + "." + methodName + "(" + ELUtil.paramString(paramTypes) + ")");
        }
        if (paramTypes == null) {
            paramTypes = ELUtil.getTypesFromValues(paramValues);
        }
        if ((result = ELUtil.findWrapper(clazz, wrappers = Wrapper.wrap(clazz, methods = clazz.getMethods(), methodName), methodName, paramTypes, paramValues)) == null) {
            return null;
        }
        return ELUtil.getMethod(clazz, (Method)result.unWrap());
    }

    private static Wrapper findWrapper(Class<?> clazz, List<Wrapper> wrappers, String name, Class<?>[] paramTypes, Object[] paramValues) {
        ArrayList<Wrapper> assignableCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> coercibleCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> varArgsCandidates = new ArrayList<Wrapper>();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        for (Wrapper w : wrappers) {
            Class<?>[] mParamTypes = w.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (paramCount != mParamCount && (!w.isVarArgs() || paramCount < mParamCount - 1)) continue;
            boolean assignable = false;
            boolean coercible = false;
            boolean varArgs = false;
            boolean noMatch = false;
            block1: for (int i = 0; i < mParamCount; ++i) {
                if (i == mParamCount - 1 && w.isVarArgs()) {
                    varArgs = true;
                    if (mParamCount == paramCount && mParamTypes[i] == paramTypes[i]) continue;
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount; ++j) {
                        if (ELUtil.isAssignableFrom(paramTypes[j], varType) || paramValues != null && j < paramValues.length && ELUtil.isCoercibleFrom(paramValues[j], varType)) continue;
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i].equals(paramTypes[i])) continue;
                if (ELUtil.isAssignableFrom(paramTypes[i], mParamTypes[i])) {
                    assignable = true;
                    continue;
                }
                if (paramValues == null || i >= paramValues.length) {
                    noMatch = true;
                    break;
                }
                if (ELUtil.isCoercibleFrom(paramValues[i], mParamTypes[i])) {
                    coercible = true;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (varArgs) {
                varArgsCandidates.add(w);
                continue;
            }
            if (coercible) {
                coercibleCandidates.add(w);
                continue;
            }
            if (assignable) {
                assignableCandidates.add(w);
                continue;
            }
            return w;
        }
        String errorMsg = "Unable to find unambiguous method: " + clazz + "." + name + "(" + ELUtil.paramString(paramTypes) + ")";
        if (!assignableCandidates.isEmpty()) {
            return ELUtil.findMostSpecificWrapper(assignableCandidates, paramTypes, false, errorMsg);
        }
        if (!coercibleCandidates.isEmpty()) {
            return ELUtil.findMostSpecificWrapper(coercibleCandidates, paramTypes, true, errorMsg);
        }
        if (!varArgsCandidates.isEmpty()) {
            return ELUtil.findMostSpecificWrapper(varArgsCandidates, paramTypes, true, errorMsg);
        }
        throw new MethodNotFoundException("Method not found: " + clazz + "." + name + "(" + ELUtil.paramString(paramTypes) + ")");
    }

    private static Wrapper findMostSpecificWrapper(List<Wrapper> candidates, Class<?>[] matchingTypes, boolean elSpecific, String errorMsg) {
        ArrayList<Wrapper> ambiguouses = new ArrayList<Wrapper>();
        for (Wrapper candidate : candidates) {
            boolean lessSpecific = false;
            Iterator it = ambiguouses.iterator();
            while (it.hasNext()) {
                int result = ELUtil.isMoreSpecific(candidate, (Wrapper)it.next(), matchingTypes, elSpecific);
                if (result == 1) {
                    it.remove();
                    continue;
                }
                if (result != -1) continue;
                lessSpecific = true;
            }
            if (lessSpecific) continue;
            ambiguouses.add(candidate);
        }
        if (ambiguouses.size() > 1) {
            throw new MethodNotFoundException(errorMsg);
        }
        return (Wrapper)ambiguouses.get(0);
    }

    private static int isMoreSpecific(Wrapper wrapper1, Wrapper wrapper2, Class<?>[] matchingTypes, boolean elSpecific) {
        Class<?>[] paramTypes1 = wrapper1.getParameterTypes();
        Class<?>[] paramTypes2 = wrapper2.getParameterTypes();
        if (wrapper1.isVarArgs()) {
            int length = Math.max(Math.max(paramTypes1.length, paramTypes2.length), matchingTypes.length);
            paramTypes1 = ELUtil.getComparingParamTypesForVarArgsMethod(paramTypes1, length);
            paramTypes2 = ELUtil.getComparingParamTypesForVarArgsMethod(paramTypes2, length);
            if (length > matchingTypes.length) {
                Class[] matchingTypes2 = new Class[length];
                System.arraycopy(matchingTypes, 0, matchingTypes2, 0, matchingTypes.length);
                matchingTypes = matchingTypes2;
            }
        }
        int result = 0;
        for (int i = 0; i < paramTypes1.length; ++i) {
            if (paramTypes1[i] == paramTypes2[i]) continue;
            int r2 = ELUtil.isMoreSpecific(paramTypes1[i], paramTypes2[i], matchingTypes[i], elSpecific);
            if (r2 == 1) {
                if (result == -1) {
                    return 0;
                }
                result = 1;
                continue;
            }
            if (r2 == -1) {
                if (result == 1) {
                    return 0;
                }
                result = -1;
                continue;
            }
            return 0;
        }
        if (result == 0) {
            result = Boolean.compare(wrapper1.isBridge(), wrapper2.isBridge());
        }
        return result;
    }

    private static int isMoreSpecific(Class<?> type1, Class<?> type2, Class<?> matchingType, boolean elSpecific) {
        type1 = ELUtil.getBoxingTypeIfPrimitive(type1);
        if ((type2 = ELUtil.getBoxingTypeIfPrimitive(type2)).isAssignableFrom(type1)) {
            return 1;
        }
        if (type1.isAssignableFrom(type2)) {
            return -1;
        }
        if (elSpecific) {
            if (matchingType != null && Number.class.isAssignableFrom(matchingType)) {
                boolean b2;
                boolean b1 = Number.class.isAssignableFrom(type1) || type1.isPrimitive();
                boolean bl = b2 = Number.class.isAssignableFrom(type2) || type2.isPrimitive();
                if (b1 && !b2) {
                    return 1;
                }
                if (b2 && !b1) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    private static Class<?> getBoxingTypeIfPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            return Double.class;
        }
        return clazz;
    }

    private static Class<?>[] getComparingParamTypesForVarArgsMethod(Class<?>[] paramTypes, int length) {
        Class[] result = new Class[length];
        System.arraycopy(paramTypes, 0, result, 0, paramTypes.length - 1);
        Class<?> type = paramTypes[paramTypes.length - 1].getComponentType();
        for (int i = paramTypes.length - 1; i < length; ++i) {
            result[i] = type;
        }
        return result;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        target = ELUtil.getBoxingTypeIfPrimitive(target);
        return target.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target) {
        try {
            ELUtil.getExpressionFactory().coerceToType(src, target);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = ELUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = ELUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> getConstructor(Class<?> type, Constructor<?> c) {
        if (c == null || Modifier.isPublic(type.getModifiers())) {
            return c;
        }
        Constructor<?> cp = null;
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                cp = sup.getConstructor(c.getParameterTypes());
                cp = ELUtil.getConstructor(cp.getDeclaringClass(), cp);
                if (cp != null) {
                    return cp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Object[] buildParameters(ELContext context, Class<?>[] parameterTypes, boolean isVarArgs, Object[] params) {
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            int paramCount;
            parameters = new Object[parameterTypes.length];
            int n = paramCount = params == null ? 0 : params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
                if (parameterTypes.length == paramCount && parameterTypes[varArgIndex] == params[varArgIndex].getClass()) {
                    parameters[varArgIndex] = params[varArgIndex];
                } else {
                    Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                    Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                    for (int i = varArgIndex; i < paramCount; ++i) {
                        Array.set(varargs, i - varArgIndex, context.convertToType(params[i], varArgClass));
                    }
                    parameters[varArgIndex] = varargs;
                }
            } else {
                for (int i = 0; i < parameterTypes.length && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
            }
        }
        return parameters;
    }

    static {
        ELUtil.setupProperties();
        instance = new ThreadLocal<Map<String, ResourceBundle>>(){

            @Override
            protected Map<String, ResourceBundle> initialValue() {
                return null;
            }
        };
    }

    private static class ConstructorWrapper
    extends Wrapper {
        private final Constructor<?> c;

        public ConstructorWrapper(Constructor<?> c) {
            this.c = c;
        }

        @Override
        public Object unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper {
        private final Method m;

        public MethodWrapper(Method m) {
            this.m = m;
        }

        @Override
        public Object unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }

    private static abstract class Wrapper {
        private Wrapper() {
        }

        public static List<Wrapper> wrap(Class<?> clazz, Method[] methods, String name) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Method method : methods) {
                if (!method.getName().equals(name) || method.isBridge() && !method.getDeclaringClass().equals(clazz)) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public static List<Wrapper> wrap(Constructor<?>[] constructors) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Constructor<?> constructor : constructors) {
                result.add(new ConstructorWrapper(constructor));
            }
            return result;
        }

        public abstract Object unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }
}

