/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jberet.spi.JobXmlResolver;

public class ChainedJobXmlResolver
implements JobXmlResolver {
    private final Set<JobXmlResolver> resolvers;

    public ChainedJobXmlResolver(JobXmlResolver ... resolvers) {
        this.resolvers = new LinkedHashSet<JobXmlResolver>(resolvers.length);
        Collections.addAll(this.resolvers, resolvers);
    }

    public ChainedJobXmlResolver(Iterable<JobXmlResolver> resolvers) {
        this.resolvers = new LinkedHashSet<JobXmlResolver>();
        for (JobXmlResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
    }

    public ChainedJobXmlResolver(Iterable<JobXmlResolver> resolvers, JobXmlResolver ... additionalResolvers) {
        this.resolvers = new LinkedHashSet<JobXmlResolver>();
        for (JobXmlResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
        Collections.addAll(this.resolvers, additionalResolvers);
    }

    public ChainedJobXmlResolver(Collection<JobXmlResolver> resolvers) {
        this.resolvers = new LinkedHashSet<JobXmlResolver>(resolvers);
    }

    @Override
    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        for (JobXmlResolver resolver : this.resolvers) {
            InputStream is = resolver.resolveJobXml(jobXml, classLoader);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        ArrayList<String> names = new ArrayList<String>();
        for (JobXmlResolver resolver : this.resolvers) {
            names.addAll(resolver.getJobXmlNames(classLoader));
        }
        return names;
    }

    @Override
    public String resolveJobName(String jobXml, ClassLoader classLoader) {
        for (JobXmlResolver resolver : this.resolvers) {
            String name = resolver.resolveJobName(jobXml, classLoader);
            if (name == null) continue;
            return name;
        }
        return null;
    }
}

