/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataQueryProtocolRequestURLBuilder
implements Function<CriteriaSet, String> {
    private final Logger log = LoggerFactory.getLogger(MetadataQueryProtocolRequestURLBuilder.class);
    private String base;
    private Function<String, String> transformer;
    private Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    private List<MetadataQueryProtocolURLBuilder> urlBuilders;

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL) {
        this(baseURL, null, null);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="transform") @Nullable Function<String, String> transform) {
        this(baseURL, transform, null);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="secondaryURLBuilders") @Nullable List<MetadataQueryProtocolURLBuilder> secondaryURLBuilders) {
        this(baseURL, null, secondaryURLBuilders);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="transform") @Nullable Function<String, String> transform, @ParameterName(name="secondaryURLBuilders") @Nullable List<MetadataQueryProtocolURLBuilder> secondaryURLBuilders) {
        this.base = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)baseURL), (String)"Base URL was null or empty");
        if (!this.base.endsWith("/")) {
            this.log.debug("Base URL did not end in a trailing '/', one will be added");
            this.base = this.base + "/";
        }
        this.log.debug("Effective base URL value was: {}", (Object)this.base);
        this.transformer = transform;
        if (secondaryURLBuilders != null) {
            this.urlBuilders = new ArrayList<MetadataQueryProtocolURLBuilder>(Collections2.filter(secondaryURLBuilders, (Predicate)Predicates.notNull()));
        }
    }

    @Nullable
    public String apply(@Nonnull CriteriaSet criteria) {
        Constraint.isNotNull((Object)criteria, (String)"Criteria was null");
        if (criteria.contains(EntityIdCriterion.class)) {
            this.log.debug("Criteria contained entity ID, building on that basis");
            return this.buildFromEntityID(((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        }
        if (this.urlBuilders != null) {
            this.log.debug("Criteria did not contain entity ID, attempting to build using secondary URL builders");
            return this.buildFromSecondaryLookups(criteria);
        }
        this.log.debug("Criteria did not contain entity ID and no secondary URL builders were configured");
        return null;
    }

    private String buildFromEntityID(@Nonnull String inputEntityID) {
        String entityID = inputEntityID;
        if (this.transformer != null) {
            entityID = (String)this.transformer.apply((Object)inputEntityID);
            this.log.debug("Transformed entityID is '{}'", (Object)entityID);
            if (entityID == null) {
                this.log.debug("Transformed entityID was null");
                return null;
            }
        }
        String result = this.base + "entities/" + this.pathEscaper.escape(entityID);
        this.log.debug("From entityID '{}' and base URL '{}', built request URL: {}", new Object[]{entityID, this.base, result});
        return result;
    }

    private String buildFromSecondaryLookups(@Nonnull CriteriaSet criteria) {
        if (this.urlBuilders != null) {
            for (MetadataQueryProtocolURLBuilder builder : this.urlBuilders) {
                String url = builder.buildURL(this.base, criteria);
                this.log.debug("Secondary URL builder '{}' produced URL: {}", (Object)builder.getClass().getName(), (Object)url);
                if (url == null) continue;
                return url;
            }
        }
        this.log.debug("No configured secondary URL builders produced a non-null request URL");
        return null;
    }

    public static interface MetadataQueryProtocolURLBuilder {
        @Nullable
        public String buildURL(@Nonnull String var1, @Nonnull CriteriaSet var2);
    }
}

