/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.persist.AbstractConditionalLoadXMLObjectLoadSaveManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MapLoadSaveManager<T extends XMLObject>
extends AbstractConditionalLoadXMLObjectLoadSaveManager<T> {
    private Logger log = LoggerFactory.getLogger(MapLoadSaveManager.class);
    private Map<String, T> backingMap;
    private Map<String, Long> dataLastModified;

    public MapLoadSaveManager() {
        this(new HashMap(), new HashMap<String, Long>(), false);
    }

    public MapLoadSaveManager(@ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this(new HashMap(), new HashMap<String, Long>(), conditionalLoad);
    }

    public MapLoadSaveManager(@ParameterName(name="map") @Nonnull Map<String, T> map) {
        this(map, new HashMap<String, Long>(), false);
    }

    protected MapLoadSaveManager(@ParameterName(name="map") @Nonnull Map<String, T> map, @ParameterName(name="dataLastModified") @Nonnull Map<String, Long> lastModifiedMap, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        super(conditionalLoad);
        this.backingMap = (Map)Constraint.isNotNull(map, (String)"Backing map was null");
        this.dataLastModified = (Map)Constraint.isNotNull(lastModifiedMap, (String)"Data last modified map was null");
    }

    @Override
    public Set<String> listKeys() throws IOException {
        return this.backingMap.keySet();
    }

    @Override
    public Iterable<Pair<String, T>> listAll() throws IOException {
        ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>();
        for (String key : this.listKeys()) {
            list.add(new Pair((Object)key, this.load(key)));
        }
        return list;
    }

    @Override
    public boolean exists(String key) throws IOException {
        return this.backingMap.containsKey(key);
    }

    @Override
    public T load(String key) throws IOException {
        if (!this.exists(key)) {
            this.log.debug("Target data with key '{}' does not exist", (Object)key);
            this.clearLoadLastModified(key);
            return null;
        }
        if (this.isLoadConditionally() && this.isUnmodifiedSinceLastLoad(key)) {
            this.log.debug("Target data with key '{}' has not been modified since the last request, returning null", (Object)key);
            return null;
        }
        this.updateLoadLastModified(key, this.dataLastModified.get(key));
        return (T)((XMLObject)this.backingMap.get(key));
    }

    @Override
    public void save(String key, T xmlObject) throws IOException {
        this.save(key, xmlObject, false);
    }

    @Override
    public void save(String key, T xmlObject, boolean overwrite) throws IOException {
        if (!overwrite && this.exists(key)) {
            throw new IOException(String.format("Value already exists for key '%s'", key));
        }
        this.backingMap.put(key, xmlObject);
        this.dataLastModified.put(key, System.currentTimeMillis());
    }

    @Override
    public boolean remove(String key) throws IOException {
        XMLObject removed = (XMLObject)this.backingMap.remove(key);
        this.dataLastModified.remove(key);
        this.clearLoadLastModified(key);
        return removed != null;
    }

    @Override
    public boolean updateKey(String currentKey, String newKey) throws IOException {
        XMLObject value = (XMLObject)this.backingMap.get(currentKey);
        if (value == null) {
            return false;
        }
        if (this.backingMap.containsKey(newKey)) {
            throw new IOException(String.format("Specified new key already exists: %s", newKey));
        }
        this.backingMap.put(newKey, value);
        this.backingMap.remove(currentKey);
        this.dataLastModified.put(newKey, this.dataLastModified.get(currentKey));
        this.dataLastModified.remove(currentKey);
        this.updateLoadLastModified(newKey, this.getLoadLastModified(currentKey));
        this.clearLoadLastModified(currentKey);
        return true;
    }

    @Override
    protected boolean isUnmodifiedSinceLastLoad(@Nonnull String key) throws IOException {
        Long lastModified = this.dataLastModified.get(key);
        this.log.trace("Key '{}' last modified was: {}", (Object)key, (Object)lastModified);
        return this.getLoadLastModified(key) != null && lastModified != null && lastModified <= this.getLoadLastModified(key);
    }
}

