/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.client;

import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.protocol.hornetq.HQPropertiesConversionInterceptor;
import org.apache.activemq.artemis.core.protocol.hornetq.client.HornetQClientProtocolManager;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ClientProtocolManagerFactory.class})
public class HornetQClientProtocolManagerFactory
implements ClientProtocolManagerFactory {
    ServerLocator locator;

    public ServerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ServerLocator locator) {
        this.locator = locator;
        locator.addIncomingInterceptor((Interceptor)new HQPropertiesConversionInterceptor(true));
        locator.addOutgoingInterceptor((Interceptor)new HQPropertiesConversionInterceptor(false));
    }

    public TransportConfiguration adaptTransportConfiguration(TransportConfiguration tc) {
        if (tc == null) {
            return null;
        }
        String factoryClassName = tc.getFactoryClassName();
        if (factoryClassName.equals("org.hornetq.core.remoting.impl.netty.NettyConnectorFactory")) {
            factoryClassName = NettyConnectorFactory.class.getName();
        }
        TransportConfiguration newConfig = new TransportConfiguration(factoryClassName, tc.getParams(), tc.getName(), tc.getExtraParams());
        return newConfig;
    }

    public ClientProtocolManager newProtocolManager() {
        return new HornetQClientProtocolManager();
    }
}

