/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jstl.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TextHandler;
import java.io.IOException;
import java.util.Iterator;

public class SetHandler
extends TagHandlerImpl {
    private final TagAttribute var;
    private final TagAttribute value = this.getAttribute("value");
    private final TagAttribute target;
    private final TagAttribute property;
    private final TagAttribute scope;

    public SetHandler(TagConfig config) {
        super(config);
        this.var = this.getAttribute("var");
        this.target = this.getAttribute("target");
        this.property = this.getAttribute("property");
        this.scope = this.getAttribute("scope");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        StringBuilder bodyValue = new StringBuilder();
        Iterator iter = TagHandlerImpl.findNextByType(this.nextHandler, TextHandler.class);
        while (iter.hasNext()) {
            TextHandler text = (TextHandler)iter.next();
            bodyValue.append(text.getText(ctx));
        }
        boolean valSet = bodyValue.length() > 0 || this.value != null && this.value.getValue().length() > 0;
        ValueExpression veObj = this.value != null ? this.value.getValueExpression(ctx, Object.class) : ctx.getExpressionFactory().createValueExpression(ctx.getFacesContext().getELContext(), bodyValue.toString(), Object.class);
        if (this.var != null) {
            String varStr = this.var.getValue(ctx);
            if (null != this.scope) {
                if (0 == this.scope.getValue().length()) {
                    throw new TagException(this.tag, "zero length scope attribute set");
                }
                String scopeStr = this.scope.isLiteral() ? this.scope.getValue() : this.scope.getValue(ctx);
                if (scopeStr.equals("page")) {
                    throw new TagException(this.tag, "page scope does not exist in Faces, consider using view scope instead.");
                }
                if (scopeStr.equals("request") || scopeStr.equals("session") || scopeStr.equals("application") || scopeStr.equals("view")) {
                    scopeStr = scopeStr + "Scope";
                }
                String expr = "#{" + scopeStr + "." + varStr + "}";
                ValueExpression lhs = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, expr, Object.class);
                lhs.setValue((ELContext)ctx, veObj.getValue((ELContext)ctx));
            } else {
                ctx.getVariableMapper().setVariable(varStr, veObj);
            }
        } else {
            if (null == this.target || null == this.target.getValue() || this.target.getValue().length() <= 0 || null == this.property || null == this.property.getValue() || this.property.getValue().length() <= 0 || !valSet) {
                throw new TagException(this.tag, "when using this tag either one of var and value, or (target, property, value) must be set.");
            }
            if (this.target.isLiteral()) {
                throw new TagException(this.tag, "value of target attribute must be an expression");
            }
            String propertyStr = null;
            propertyStr = this.property.isLiteral() ? this.property.getValue() : this.property.getValue(ctx);
            ValueExpression targetVe = this.target.getValueExpression(ctx, Object.class);
            Object targetValue = targetVe.getValue((ELContext)ctx);
            ctx.getFacesContext().getELContext().getELResolver().setValue((ELContext)ctx, targetValue, (Object)propertyStr, veObj.getValue((ELContext)ctx));
        }
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) {
    }
}

