/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.jboss.logging.Logger;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleSymmetricClusterTest
extends ClusterTestBase {
    private static final Logger log = Logger.getLogger(SimpleSymmetricClusterTest.class);
    static int loopNumber;

    public boolean isNetty() {
        return false;
    }

    @Test
    public void testSimpleWithBackup() throws Exception {
        int i;
        this.setupBackupServer(0, 3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(1, 4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(2, 5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupLiveServer(3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 3, 4, 5);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 4, 3, 5);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 5, 3, 4);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 4, 5);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 3, 5);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 3, 4);
        this.startServers(0, 1, 2, 3, 4, 5);
        log.debug((Object)"");
        for (i = 0; i <= 5; ++i) {
            log.debug((Object)this.servers[i].describe());
            log.debug((Object)this.debugBindings(this.servers[i], this.servers[i].getConfiguration().getManagementNotificationAddress().toString()));
        }
        log.debug((Object)"");
        log.debug((Object)"");
        for (i = 0; i <= 5; ++i) {
            log.debug((Object)this.servers[i].describe());
            log.debug((Object)this.debugBindings(this.servers[i], this.servers[i].getConfiguration().getManagementNotificationAddress().toString()));
        }
        log.debug((Object)"");
        this.stopServers(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testSimple() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)3);
        SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)3);
        SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[2], (int)3);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
    }

    @Test
    public void testDeleteAddress() throws Exception {
        String ADDRESS = "queues.testaddress";
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        Collection bindings = this.servers[0].getPostOffice().getDirectBindings(SimpleString.toSimpleString((String)"queues.testaddress"));
        SimpleSymmetricClusterTest.assertEquals((long)2L, (long)bindings.size());
        SimpleString snf = null;
        for (Binding binding : bindings) {
            if (!(binding instanceof RemoteQueueBinding)) continue;
            snf = ((RemoteQueueBinding)binding).getQueue().getName();
        }
        SimpleSymmetricClusterTest.assertNotNull(snf);
        SimpleSymmetricClusterTest.assertNotNull((Object)this.servers[0].locateQueue(snf));
        this.servers[0].getActiveMQServerControl().deleteAddress("queues.testaddress", true);
        bindings = this.servers[0].getPostOffice().getDirectBindings(SimpleString.toSimpleString((String)"queues.testaddress"));
        SimpleSymmetricClusterTest.assertEquals((long)0L, (long)bindings.size());
        SimpleSymmetricClusterTest.assertNotNull((Object)this.servers[0].locateQueue(snf));
    }

    @Test
    public void testSimple_TwoNodes() throws Exception {
        this.setupServer(0, false, this.isNetty());
        this.setupServer(1, false, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.closeAllConsumers();
    }

    public void _testLoop() throws Throwable {
        for (int i = 0; i < 10; ++i) {
            loopNumber = i;
            log.debug((Object)("#test " + i));
            this.testSimple();
            this.tearDown();
            this.setUp();
        }
    }

    @Test
    public void testSimple2() throws Exception {
        int i;
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupServer(3, true, this.isNetty());
        this.setupServer(4, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 4, 0, 1, 2, 3);
        this.startServers(0, 1, 2, 3, 4);
        for (i = 0; i <= 4; ++i) {
            SimpleSymmetricClusterTest.waitForTopology((ActiveMQServer)this.servers[i], (int)5);
        }
        log.debug((Object)"All the servers have been started already!");
        for (i = 0; i <= 4; ++i) {
            this.setupSessionFactory(i, this.isNetty());
        }
        for (i = 0; i <= 4; ++i) {
            this.createQueue(i, "queues.testaddress", "queue0", null, false);
        }
        for (i = 0; i <= 4; ++i) {
            this.addConsumer(i, i, "queue0", null);
        }
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
    }

    @Test
    public void testSimpleRoundRobbin() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobin(33, 0, 1, 2);
        this.stopServers(2);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 100, true, null);
        this.verifyReceiveRoundRobin(100, 0, 1);
        this.sfs[2] = null;
        this.consumers[2] = null;
        this.startServers(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobinInSomeOrder(33, 2, 0, 1);
    }

    @Test
    @Ignore(value="Test not implemented yet")
    public void testSimpleRoundRobbinNoFailure() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobin(33, 0, 1, 2);
        this.stopServers(2);
        this.send(0, "queues.testaddress", 100, true, null);
        this.verifyReceiveRoundRobin(100, 0, 1, -1);
        this.sfs[2] = null;
        this.consumers[2] = null;
        this.startServers(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.verifyReceiveRoundRobin(100, -1, -1, 2);
    }
}

