/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.Assert;
import org.junit.Test;

public class NettyReplicationStopTest
extends FailoverTestBase {
    @Override
    protected TestableServer createTestableServer(Configuration config) {
        return new SameProcessActiveMQServer(this.createServer(true, config));
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected NodeManager createNodeManager() throws Exception {
        return new InVMNodeManager(false);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected final void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                NettyReplicationStopTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            NettyReplicationStopTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected final void crash(ClientSession ... sessions) throws Exception {
        this.crash(true, sessions);
    }

    @Test
    public void testReplicaStop() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", "127.0.0.1");
        TransportConfiguration tc = NettyReplicationStopTest.createTransportConfiguration((boolean)true, (boolean)false, params);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc})).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        final ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession session = sf.createSession(true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 10;
        ReplicationEndpoint endpoint = NettyReplicationStopTest.getReplicationEndpoint((ActiveMQServer)this.backupServer.getServer());
        endpoint.pause();
        ArrayList<1> threads = new ArrayList<1>();
        final ArrayList codesSent = new ArrayList();
        final CountDownLatch alignedOnSend = new CountDownLatch(10);
        int i = 0;
        while (i < 10) {
            final int code = i++;
            Thread t = new Thread("WillSend " + code){

                @Override
                public void run() {
                    try {
                        ClientSession session = sf.createSession(true, true);
                        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
                        ClientMessage message = session.createMessage(true).putIntProperty("i", code);
                        alignedOnSend.countDown();
                        producer.send((Message)message);
                        codesSent.add(code);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            threads.add(t);
        }
        Assert.assertTrue((boolean)alignedOnSend.await(10L, TimeUnit.SECONDS));
        this.liveServer.stop();
        Assert.assertEquals((long)0L, (long)codesSent.size());
    }
}

