/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.tests.integration.cluster.failover.StaticClusterWithBackupFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Ignore;
import org.junit.Test;

public class QuorumFailOverLiveVotesTest
extends StaticClusterWithBackupFailoverTest {
    @Override
    protected void setupServers() throws Exception {
        super.setupServers();
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicaPolicyConfiguration)this.servers[4].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicaPolicyConfiguration)this.servers[5].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setVoteRetries(5);
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setVoteRetryWait(500L);
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
    }

    @Ignore
    @Test
    public void testQuorumVotingLiveNotDead() throws Exception {
        int[] liveServerIDs = new int[]{0, 1, 2};
        this.setupCluster();
        this.startServers(0, 1, 2);
        new BackupSyncDelay(this.servers[4], this.servers[1], 121);
        this.startServers(3, 4, 5);
        for (int i : liveServerIDs) {
            QuorumFailOverLiveVotesTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[0]).isReplicaSync());
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[1]).isReplicaSync());
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[2]).isReplicaSync());
        for (int i : liveServerIDs) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
            this.addConsumer(i, i, "queue0", null);
        }
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        TopologyListener liveTopologyListener = new TopologyListener("LIVE-1");
        this.locators[0].addClusterTopologyListener((ClusterTopologyListener)liveTopologyListener);
        QuorumFailOverLiveVotesTest.assertTrue((String)"we assume 3 is a backup", (boolean)this.servers[3].getHAPolicy().isBackup());
        QuorumFailOverLiveVotesTest.assertFalse((String)"no shared storage", (boolean)this.servers[3].getHAPolicy().isSharedStore());
        SharedNothingLiveActivation liveActivation = (SharedNothingLiveActivation)this.servers[0].getActivation();
        this.servers[0].getRemotingService().freeze(null, null);
        this.waitForFailoverTopology(4, 3, 1, 2);
        this.waitForFailoverTopology(5, 3, 1, 2);
        QuorumFailOverLiveVotesTest.assertTrue((boolean)this.servers[3].waitForActivation(2L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[3]).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[3]).isActive());
        Wait.assertTrue(() -> ((ActiveMQServer)this.servers[0]).isReplicaSync());
        liveActivation.freezeReplication();
        Wait.assertFalse(() -> ((ActiveMQServer)this.servers[0]).isStarted());
        Wait.assertFalse(() -> ((ActiveMQServer)this.servers[0]).isActive());
    }

    @Override
    protected boolean isSharedStorage() {
        return false;
    }

    private static class TopologyListener
    implements ClusterTopologyListener {
        final String prefix;
        final Map<String, Pair<TransportConfiguration, TransportConfiguration>> nodes = new ConcurrentHashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();

        private TopologyListener(String string) {
            this.prefix = string;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            Pair connectorPair = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
            this.nodes.put(topologyMember.getBackupGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)connectorPair);
        }

        public void nodeDown(long eventUID, String nodeID) {
            this.nodes.remove(nodeID);
        }

        public String toString() {
            return "TopologyListener(" + this.prefix + ", #=" + this.nodes.size() + ")";
        }
    }
}

