/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQPToJMSCoreTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    protected String queueName = "amqTestQueue1";
    private SimpleString coreQueue;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.getAddressesSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(new SimpleString("ActiveMQ.DLQ")));
        serverConfig.setSecurityEnabled(false);
        this.coreQueue = new SimpleString(this.queueName);
        this.server.createQueue(new QueueConfiguration(this.coreQueue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageDestination() throws Exception {
        AmqpClient client = new AmqpClient(new URI("tcp://127.0.0.1:61616"), null, null);
        try (AmqpConnection amqpconnection = client.connect();){
            AmqpSession session = amqpconnection.createSession();
            AmqpSender sender = session.createSender(this.queueName);
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("MessageID:0");
            message.getWrappedMessage().setHeader(new Header());
            message.getWrappedMessage().getHeader().setDeliveryCount(new UnsignedInteger(2));
            sender.send(message);
        }
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
        try (Connection connection = null;){
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)ActiveMQJMSClient.createQueue((String)this.queueName));
            connection.start();
            Message message = consumer.receive(2000L);
            Assert.assertNotNull((Object)message);
            ActiveMQDestination jmsDestination = (ActiveMQDestination)message.getJMSDestination();
            Assert.assertEquals((Object)this.queueName, (Object)jmsDestination.getAddress());
        }
    }
}

