/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ManagementTestBase
extends ActiveMQTestBase {
    protected MBeanServer mbeanServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void consumeMessages(int expected, ClientSession session, SimpleString queue) throws Exception {
        try (ClientConsumer consumer = null;){
            consumer = session.createConsumer(queue);
            ClientMessage m = null;
            for (int i = 0; i < expected; ++i) {
                m = consumer.receive(500L);
                Assert.assertNotNull((String)("expected to received " + expected + " messages, got only " + i), (Object)m);
                m.acknowledge();
            }
            session.commit();
            m = consumer.receiveImmediate();
            Assert.assertNull((String)("received one more message than expected (" + expected + ")"), (Object)m);
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createMBeanServer();
    }

    protected void createMBeanServer() {
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
    }

    @After
    public void tearDown() throws Exception {
        MBeanServerFactory.releaseMBeanServer(this.mbeanServer);
        super.tearDown();
    }

    protected void checkNoResource(ObjectName on) {
        Assert.assertFalse((String)("unexpected resource for " + on), (boolean)this.mbeanServer.isRegistered(on));
    }

    protected void checkResource(ObjectName on) {
        Assert.assertTrue((String)("no resource for " + on), (boolean)this.mbeanServer.isRegistered(on));
    }

    protected QueueControl createManagementControl(String address, String queue) throws Exception {
        return this.createManagementControl(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queue));
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, this.mbeanServer);
        return queueControl;
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue, RoutingType routingType) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, routingType, this.mbeanServer);
        return queueControl;
    }

    protected long getMessageCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getMessageCount();
    }

    protected int getGroupCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getGroupCount();
    }

    protected long getDurableMessageCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getDurableMessageCount();
    }

    protected long getMessageSize(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getPersistentSize();
    }

    protected long getDurableMessageSize(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getDurablePersistentSize();
    }

    protected long getMessagesAdded(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getMessagesAdded();
    }
}

