/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DivertConfigurationStorageTest
extends StorageManagerTestBase {
    public DivertConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testStoreDivertConfiguration() throws Exception {
        this.createStorage();
        DivertConfiguration configuration = new DivertConfiguration();
        configuration.setName("name");
        configuration.setAddress("address");
        configuration.setExclusive(true);
        configuration.setForwardingAddress("forward");
        configuration.setRoutingName("routiingName");
        TransformerConfiguration mytransformer = new TransformerConfiguration("mytransformer");
        mytransformer.getProperties().put("key1", "prop1");
        mytransformer.getProperties().put("key2", "prop2");
        mytransformer.getProperties().put("key3", "prop3");
        configuration.setTransformerConfiguration(mytransformer);
        this.journal.storeDivertConfiguration(new PersistedDivertConfiguration(configuration));
        this.journal.stop();
        this.journal.start();
        List divertConfigurations = this.journal.recoverDivertConfigurations();
        Assert.assertEquals((long)1L, (long)divertConfigurations.size());
        PersistedDivertConfiguration persistedDivertConfiguration = (PersistedDivertConfiguration)divertConfigurations.get(0);
        Assert.assertEquals((Object)configuration.getName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getName());
        Assert.assertEquals((Object)configuration.getAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getAddress());
        Assert.assertEquals((Object)configuration.isExclusive(), (Object)persistedDivertConfiguration.getDivertConfiguration().isExclusive());
        Assert.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getForwardingAddress());
        Assert.assertEquals((Object)configuration.getRoutingName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getRoutingName());
        Assert.assertNotNull((Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration());
        Assert.assertEquals((Object)"mytransformer", (Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration().getClassName());
        Map properties = persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration().getProperties();
        Assert.assertEquals((long)3L, (long)properties.size());
        Assert.assertEquals((Object)"prop1", properties.get("key1"));
        Assert.assertEquals((Object)"prop2", properties.get("key2"));
        Assert.assertEquals((Object)"prop3", properties.get("key3"));
        this.journal.stop();
        this.journal = null;
    }

    @Test
    public void testStoreDivertConfigurationNoTransformer() throws Exception {
        this.createStorage();
        DivertConfiguration configuration = new DivertConfiguration();
        configuration.setName("name");
        configuration.setAddress("address");
        configuration.setExclusive(true);
        configuration.setForwardingAddress("forward");
        configuration.setRoutingName("routiingName");
        this.journal.storeDivertConfiguration(new PersistedDivertConfiguration(configuration));
        this.journal.stop();
        this.journal.start();
        List divertConfigurations = this.journal.recoverDivertConfigurations();
        Assert.assertEquals((long)1L, (long)divertConfigurations.size());
        PersistedDivertConfiguration persistedDivertConfiguration = (PersistedDivertConfiguration)divertConfigurations.get(0);
        Assert.assertEquals((Object)configuration.getName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getName());
        Assert.assertEquals((Object)configuration.getAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getAddress());
        Assert.assertEquals((Object)configuration.isExclusive(), (Object)persistedDivertConfiguration.getDivertConfiguration().isExclusive());
        Assert.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getForwardingAddress());
        Assert.assertEquals((Object)configuration.getRoutingName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getRoutingName());
        Assert.assertNull((Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration());
        this.journal.stop();
        this.journal = null;
    }
}

