/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.integration.replication.SharedNothingReplicationTest;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PluggableQuorumReplicationTest
extends SharedNothingReplicationTest {
    private DistributedPrimitiveManagerConfiguration managerConfiguration;

    @Before
    public void init() throws IOException {
        this.managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
    }

    @Override
    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    @Override
    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    @Test
    public void testUnReplicatedOrderedTransition() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"(tcp://localhost:61616,tcp://localhost:61617)?ha=true");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession clientSession = csf.createSession();
        clientSession.createQueue(new QueueConfiguration("slow").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)liveServer, (int)1, (int)1, (long)30000L);
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)backupServer, (int)1, (int)1, (long)30000L);
        liveServer.stop();
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(new QueueConfiguration("slow_un_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)backupServer, (int)1, (int)0, (long)30000L);
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence()));
        backupServer.stop(false);
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.assertFalse(() -> ((ActiveMQServer)liveServer).isActive());
        liveServer.stop();
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        PluggableQuorumReplicationTest.assertEquals((long)3L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(new QueueConfiguration("backup_as_un_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        liveServer.start();
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(new QueueConfiguration("backup_as_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 3L == liveServer.getNodeManager().getNodeActivationSequence()));
        backupServer.stop(true);
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)liveServer, (int)1, (int)0, (long)30000L);
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 4L == liveServer.getNodeManager().getNodeActivationSequence()));
        liveServer.stop(true);
        clientSession.close();
        locator.close();
    }

    @Test
    public void testBackupFailoverAndPrimaryFailback() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assert.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        primaryInstance.stop();
        Wait.assertTrue(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        TimeUnit.MILLISECONDS.sleep(100L);
        ActiveMQServer restartedPrimaryForFailBack = primaryInstance;
        restartedPrimaryForFailBack.start();
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> {
            try {
                return 3L == restartedPrimaryForFailBack.getNodeManager().getNodeActivationSequence();
            }
            catch (NullPointerException ok) {
                return false;
            }
        }, (long)timeout);
        Wait.assertTrue(() -> restartedPrimaryForFailBack.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> 3L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        TimeUnit.MILLISECONDS.sleep(100L);
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(100L);
        Wait.assertTrue(() -> {
            try {
                return 4L == restartedPrimaryForFailBack.getNodeManager().getNodeActivationSequence();
            }
            catch (NullPointerException ok) {
                return false;
            }
        }, (long)timeout);
        restartedPrimaryForFailBack.stop();
    }

    @Test
    public void testPrimaryIncrementActivationSequenceOnUnReplicated() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assert.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        backupServer.stop();
        Wait.assertTrue(() -> 2L == primaryInstance.getNodeManager().getNodeActivationSequence(), (long)timeout);
        primaryInstance.stop();
    }

    @Test
    public void testBackupStartsFirst() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
    }

    @Test
    public void testBackupOutOfSequenceReleasesLock() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
        backupServer.stop();
        TimeUnit.SECONDS.sleep(1L);
        liveServer.stop();
        backupServer.start();
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
    }

    @Test
    public void testBackupOutOfSequenceCheckActivationSequence() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
        backupServer.stop();
        TimeUnit.SECONDS.sleep(1L);
        String coordinatedId = liveServer.getNodeID().toString();
        liveServer.stop();
        DistributedPrimitiveManager distributedPrimitiveManager = DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedPrimitiveManager.start();
        DistributedLock lock = distributedPrimitiveManager.getDistributedLock(coordinatedId);
        PluggableQuorumReplicationTest.assertTrue((boolean)lock.tryLock());
        final CountDownLatch preActivate = new CountDownLatch(1);
        backupServer.registerActivateCallback(new ActivateCallback(){

            public void preActivate() {
                super.preActivate();
                preActivate.countDown();
            }
        });
        backupServer.start();
        PluggableQuorumReplicationTest.assertTrue((boolean)preActivate.await(1L, TimeUnit.SECONDS));
        distributedPrimitiveManager.stop();
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
    }

    @Test
    public void testSelfRepairPrimary() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        String coordinatedId = liveServer.getNodeID().toString();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        liveServer.stop();
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        Assert.assertEquals((long)2L, (long)liveServer.getNodeManager().getNodeActivationSequence());
        liveServer.stop();
        DistributedPrimitiveManager distributedPrimitiveManager = DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedPrimitiveManager.start();
        try (DistributedLock lock = distributedPrimitiveManager.getDistributedLock(coordinatedId);){
            PluggableQuorumReplicationTest.assertTrue((boolean)lock.tryLock());
            distributedPrimitiveManager.getMutableLong(coordinatedId).compareAndSet(2L, -2L);
        }
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        Assert.assertEquals((long)2L, (long)liveServer.getNodeManager().getNodeActivationSequence());
        Assert.assertEquals((long)2L, (long)distributedPrimitiveManager.getMutableLong(coordinatedId).get());
        distributedPrimitiveManager.stop();
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync());
        Assert.assertEquals((long)2L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        backupServer.stop();
    }

    @Test
    public void testPrimaryPeers() throws Exception {
        String PEER_NODE_ID = "some-shared-id-001";
        Configuration liveConfiguration = this.createLiveConfiguration();
        ((ReplicationPrimaryPolicyConfiguration)liveConfiguration.getHAPolicyConfiguration()).setCoordinationId("some-shared-id-001");
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"(tcp://localhost:61616,tcp://localhost:61617)?ha=true");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory keepLocatorAliveSLF = locator.createSessionFactory();
        ClientSessionFactory csf = locator.createSessionFactory();
        this.sendTo(csf, "live_un_replicated");
        csf.close();
        Configuration peerLiveConfiguration = this.createBackupConfiguration();
        peerLiveConfiguration.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ((ReplicationPrimaryPolicyConfiguration)peerLiveConfiguration.getHAPolicyConfiguration()).setCoordinationId("some-shared-id-001");
        peerLiveConfiguration.setName("localhost::live-peer");
        ActiveMQServer livePeerServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)peerLiveConfiguration));
        livePeerServer.setIdentity("LIVE-PEER");
        livePeerServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)livePeerServer).isStarted());
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)liveServer, (int)1, (int)1, (long)30000L);
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)livePeerServer, (int)1, (int)1, (long)30000L);
        liveServer.stop();
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "live_un_replicated");
        this.sendTo(csf, "peer_un_replicated");
        csf.close();
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)livePeerServer, (int)1, (int)0, (long)30000L);
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 2L == livePeerServer.getNodeManager().getNodeActivationSequence()));
        livePeerServer.stop(false);
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.assertTrue(() -> !liveServer.isActive());
        livePeerServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)livePeerServer).isStarted());
        PluggableQuorumReplicationTest.assertEquals((long)3L, (long)livePeerServer.getNodeManager().getNodeActivationSequence());
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "peer_un_replicated");
        this.sendTo(csf, "backup_as_un_replicated");
        csf.close();
        liveServer.start();
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "backup_as_un_replicated");
        this.sendTo(csf, "backup_as_replicated");
        csf.close();
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 3L == liveServer.getNodeManager().getNodeActivationSequence()));
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)liveServer, (int)1, (int)1, (long)30000L);
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)livePeerServer, (int)1, (int)1, (long)30000L);
        livePeerServer.stop(true);
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 4L == liveServer.getNodeManager().getNodeActivationSequence()));
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "backup_as_replicated");
        csf.close();
        PluggableQuorumReplicationTest.waitForTopology((ActiveMQServer)liveServer, (int)1, (int)0, (long)30000L);
        liveServer.stop(true);
        keepLocatorAliveSLF.close();
        locator.close();
    }

    @Test
    public void testUnavailableSelfHeal() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
        String coordinatedId = liveServer.getNodeID().toString();
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(500L);
        liveServer.stop();
        DistributedPrimitiveManager distributedPrimitiveManager = DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedPrimitiveManager.start();
        MutableLong activationSequence = distributedPrimitiveManager.getMutableLong(coordinatedId);
        Assert.assertTrue((boolean)activationSequence.compareAndSet(2L, -2L));
        backupServer.start();
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
    }

    @Test
    public void testUnavailableAdminIntervention() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
        String coordinatedId = liveServer.getNodeID().toString();
        System.err.println("coodr id: " + coordinatedId);
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(500L);
        liveServer.stop();
        DistributedPrimitiveManager distributedPrimitiveManager = DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedPrimitiveManager.start();
        MutableLong coordinatedActivationSequence = distributedPrimitiveManager.getMutableLong(coordinatedId);
        Assert.assertTrue((boolean)coordinatedActivationSequence.compareAndSet(2L, -2L));
        FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(liveConfiguration.getNodeManagerLockLocation().getAbsoluteFile(), true);
        fileLockNodeManager.start();
        PluggableQuorumReplicationTest.assertEquals((long)2L, (long)fileLockNodeManager.readNodeActivationSequence());
        fileLockNodeManager.writeNodeActivationSequence(1L);
        fileLockNodeManager.stop();
        backupServer.start();
        CountDownLatch liveStarting = new CountDownLatch(1);
        Thread liveServerStarterThread = new Thread(() -> {
            liveStarting.countDown();
            try {
                liveServer.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        liveServerStarterThread.start();
        liveStarting.await();
        TimeUnit.MILLISECONDS.sleep(500L);
        Assert.assertTrue((boolean)coordinatedActivationSequence.compareAndSet(-2L, 1L));
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> liveServer.isStarted() || backupServer.isStarted());
        PluggableQuorumReplicationTest.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        PluggableQuorumReplicationTest.assertTrue((boolean)liveServer.isReplicaSync());
        PluggableQuorumReplicationTest.assertEquals((long)2L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        PluggableQuorumReplicationTest.assertEquals((long)2L, (long)liveServer.getNodeManager().getNodeActivationSequence());
    }

    private void sendTo(ClientSessionFactory clientSessionFactory, String addr) throws Exception {
        ClientSession clientSession = clientSessionFactory.createSession(true, true);
        clientSession.createQueue(new QueueConfiguration(addr).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        ClientProducer producer = clientSession.createProducer(addr);
        ClientMessage message = clientSession.createMessage(true);
        message.putStringProperty("K", addr);
        message.putLongProperty("delay", 0L);
        producer.send((Message)message);
        producer.close();
        clientSession.close();
    }

    private void receiveFrom(ClientSessionFactory clientSessionFactory, String addr) throws Exception {
        ClientSession clientSession = clientSessionFactory.createSession(true, true);
        clientSession.start();
        ClientConsumer consumer = clientSession.createConsumer(addr);
        ClientMessage message = consumer.receive(4000L);
        PluggableQuorumReplicationTest.assertNotNull((Object)message);
        PluggableQuorumReplicationTest.assertTrue((boolean)message.getStringProperty("K").equals(addr));
        consumer.close();
        clientSession.close();
    }
}

