/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.tests.integration.rest.util.ResponseUtil;
import org.apache.activemq.artemis.tests.integration.rest.util.RestAMQConnection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public abstract class RestMessageContext
implements Closeable {
    public static final String KEY_MSG_CREATE = "msg-create";
    public static final String KEY_MSG_CREATE_ID = "msg-create-with-id";
    public static final String KEY_MSG_PULL = "msg-pull-consumers";
    public static final String KEY_MSG_PUSH = "msg-push-consumers";
    public static final String KEY_MSG_PULL_SUB = "msg-pull-subscriptions";
    public static final String KEY_MSG_PUSH_SUB = "msg-push-subscriptions";
    public static final String KEY_MSG_CREATE_NEXT = "msg-create-next";
    public static final String KEY_PULL_CONSUMERS_LOC = "pull-consumers-location";
    public static final String KEY_MSG_CONSUME_NEXT = "msg-consume-next";
    public static final String KEY_MSG_CONSUMER = "msg-consumer";
    public static final String KEY_MSG_ACK_NEXT = "msg-acknowledge-next";
    public static final String KEY_MSG_ACK = "msg-acknowledgement";
    protected RestAMQConnection connection;
    protected String destination;
    protected Map<String, String> contextMap = new HashMap<String, String>();
    protected boolean autoAck;
    protected boolean pushConsumer;

    public RestMessageContext(RestAMQConnection restAMQConnection, String dest) throws IOException {
        this(restAMQConnection, dest, true, false);
    }

    public RestMessageContext(RestAMQConnection restAMQConnection, String dest, boolean isAutoAck, boolean isPush) throws IOException {
        this.connection = restAMQConnection;
        this.destination = dest;
        this.autoAck = isAutoAck;
        this.pushConsumer = isPush;
        this.prepareSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSelf() throws IOException {
        String destLink = this.getDestLink();
        CloseableHttpResponse response = this.connection.request(destLink);
        int code = ResponseUtil.getHttpCode(response);
        if (code != 200) {
            System.out.println("failed to init " + destLink);
            System.out.println("reason: " + ResponseUtil.getDetails(response));
        }
        try {
            Header header = response.getFirstHeader(KEY_MSG_CREATE);
            this.contextMap.put(KEY_MSG_CREATE, header.getValue());
            header = response.getFirstHeader(KEY_MSG_CREATE_ID);
            this.contextMap.put(KEY_MSG_CREATE_ID, header.getValue());
            header = response.getFirstHeader(KEY_MSG_PULL);
            if (header != null) {
                this.contextMap.put(KEY_MSG_PULL, header.getValue());
            }
            if ((header = response.getFirstHeader(KEY_MSG_PUSH)) != null) {
                this.contextMap.put(KEY_MSG_PUSH, header.getValue());
            }
            if ((header = response.getFirstHeader(KEY_MSG_PULL_SUB)) != null) {
                this.contextMap.put(KEY_MSG_PULL_SUB, header.getValue());
            }
            if ((header = response.getFirstHeader(KEY_MSG_PUSH_SUB)) != null) {
                this.contextMap.put(KEY_MSG_PUSH_SUB, header.getValue());
            }
        }
        finally {
            response.close();
        }
    }

    protected abstract String getDestLink();

    protected abstract String getPullConsumerUri();

    protected abstract String getPushLink(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postMessage(String content, String type) throws IOException {
        String nextMsgUri = this.contextMap.get(KEY_MSG_CREATE_NEXT);
        String postUri = nextMsgUri == null ? this.contextMap.get(KEY_MSG_CREATE) : nextMsgUri;
        int code = -1;
        try (CloseableHttpResponse response = this.connection.post(postUri, type, content);){
            code = ResponseUtil.getHttpCode(response);
            if (code == 307) {
                Header redirLoc = response.getFirstHeader("Location");
                this.contextMap.put(KEY_MSG_CREATE_NEXT, redirLoc.getValue());
                code = this.postMessage(content, type);
            } else if (code == 201) {
                Header header = response.getFirstHeader(KEY_MSG_CREATE_NEXT);
                this.contextMap.put(KEY_MSG_CREATE_NEXT, header.getValue());
            }
        }
        return code;
    }

    public abstract void initPullConsumers() throws IOException;

    public boolean acknowledgement(boolean ackValue) throws IOException {
        String ackUri = this.contextMap.get(KEY_MSG_ACK);
        if (ackUri != null) {
            CloseableHttpResponse response = this.connection.post(ackUri, "application/x-www-form-urlencoded", "acknowledge=" + ackValue);
            int code = ResponseUtil.getHttpCode(response);
            if (code == 200) {
                this.contextMap.put(KEY_MSG_ACK_NEXT, response.getFirstHeader(KEY_MSG_ACK_NEXT).getValue());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pullMessage() throws IOException {
        String message;
        block17: {
            message = null;
            String msgPullUri = null;
            if (this.autoAck) {
                msgPullUri = this.contextMap.get(KEY_MSG_CONSUME_NEXT);
                if (msgPullUri == null) {
                    this.initPullConsumers();
                    msgPullUri = this.contextMap.get(KEY_MSG_CONSUME_NEXT);
                }
            } else {
                msgPullUri = this.contextMap.get(KEY_MSG_ACK_NEXT);
                if (msgPullUri == null) {
                    this.initPullConsumers();
                    msgPullUri = this.contextMap.get(KEY_MSG_ACK_NEXT);
                }
            }
            CloseableHttpResponse response = this.connection.post(msgPullUri);
            int code = ResponseUtil.getHttpCode(response);
            try {
                if (code == 200) {
                    HttpEntity entity = response.getEntity();
                    long len = entity.getContentLength();
                    if (len != -1L && len < 1024000L) {
                        message = EntityUtils.toString((HttpEntity)entity);
                    } else {
                        System.err.println("Message too large, drop it " + len);
                    }
                    Header header = response.getFirstHeader(KEY_MSG_CONSUMER);
                    this.contextMap.put(KEY_MSG_CONSUMER, header.getValue());
                    if (!this.autoAck) {
                        header = response.getFirstHeader(KEY_MSG_ACK);
                        this.contextMap.put(KEY_MSG_ACK, header.getValue());
                    } else {
                        header = response.getFirstHeader(KEY_MSG_CONSUME_NEXT);
                        this.contextMap.put(KEY_MSG_CONSUME_NEXT, header.getValue());
                    }
                    break block17;
                }
                if (code == 503) {
                    if (this.autoAck) {
                        this.contextMap.put(KEY_MSG_CONSUME_NEXT, response.getFirstHeader(KEY_MSG_CONSUME_NEXT).getValue());
                    } else {
                        this.contextMap.put(KEY_MSG_ACK_NEXT, response.getFirstHeader(KEY_MSG_ACK_NEXT).getValue());
                    }
                    Header header = response.getFirstHeader("Retry-After");
                    if (header == null) break block17;
                    long retryDelay = Long.valueOf(response.getFirstHeader("Retry-After").getValue());
                    try {
                        Thread.sleep(retryDelay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    message = this.pullMessage();
                    break block17;
                }
                throw new IllegalStateException("error: " + ResponseUtil.getDetails(response));
            }
            finally {
                response.close();
            }
        }
        return message;
    }

    @Override
    public void close() {
        String consumerUri = this.contextMap.get(KEY_MSG_CONSUMER);
        if (consumerUri != null) {
            try {
                this.connection.delete(consumerUri);
                this.contextMap.remove(KEY_MSG_CONSUMER);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpPush(String pushTarget) throws Exception {
        String pushLink = this.contextMap.get(KEY_MSG_PUSH);
        String pushRegXml = "<push-registration><link rel=\"destination\" href=\"" + this.connection.getTargetUri() + this.getPushLink(pushTarget) + "\"/></push-registration>";
        CloseableHttpResponse response = this.connection.post(pushLink, "application/xml", pushRegXml);
        int code = ResponseUtil.getHttpCode(response);
        try {
            if (code != 201) {
                System.out.println("Failed to push " + pushRegXml);
                System.out.println("Location: " + pushLink);
                throw new Exception("Failed to register push " + ResponseUtil.getDetails(response));
            }
        }
        finally {
            response.close();
        }
    }
}

