/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.tests.unit.ra.BootstrapContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class ActiveMQXAResourceWrapperTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMe() throws Exception {
        ActiveMQServer server = this.createServer(false, true);
        ActiveMQResourceAdapter ra = null;
        ClientSession cs = null;
        try {
            server.getConfiguration().setSecurityEnabled(false);
            server.start();
            ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY);
            ra.setConnectionTTL(Long.valueOf(4000L));
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            TestActiveMQXAResourceWrapper wrapper = new TestActiveMQXAResourceWrapper(ra.getRecoveryManager().getResources().toArray(new XARecoveryConfig[0]));
            XAResource res = wrapper.connect();
            if (!(res instanceof ClientSession)) {
                ActiveMQXAResourceWrapperTest.fail((String)"Unexpected XAResource type");
            }
            cs = (ClientSession)res;
            ActiveMQXAResourceWrapperTest.assertEquals((long)4000L, (long)cs.getSessionFactory().getServerLocator().getConnectionTTL());
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (ra != null) {
                ra.stop();
            }
            server.stop();
        }
    }

    class TestActiveMQXAResourceWrapper
    extends ActiveMQXAResourceWrapper {
        TestActiveMQXAResourceWrapper(XARecoveryConfig[] configs) {
            super(configs);
        }

        protected XAResource connect() throws Exception {
            return super.connect();
        }
    }
}

