/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration.recovery;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.jboss.activemq.artemis.wildfly.integration.recovery.WildFlyActiveMQLogger;
import org.jboss.activemq.artemis.wildfly.integration.recovery.WildFlyActiveMQRecoveryRegistry;

public class WildFlyRecoveryDiscovery
implements SessionFailureListener {
    private ServerLocator locator;
    private ClientSessionFactoryInternal sessionFactory;
    private final XARecoveryConfig config;
    private final AtomicInteger usage = new AtomicInteger(0);
    private boolean started = false;

    public WildFlyRecoveryDiscovery(XARecoveryConfig config) {
        this.config = config;
    }

    public synchronized void start(boolean retry) {
        if (!this.started) {
            WildFlyActiveMQLogger.LOGGER.debug("Starting RecoveryDiscovery on " + this.config);
            this.started = true;
            this.locator = this.config.createServerLocator();
            this.locator.disableFinalizeCheck();
            this.locator.addClusterTopologyListener((ClusterTopologyListener)new InternalListener(this.config));
            try {
                this.sessionFactory = (ClientSessionFactoryInternal)this.locator.createSessionFactory();
                this.sessionFactory.addFailureListener((SessionFailureListener)this);
                WildFlyActiveMQLogger.LOGGER.debug("RecoveryDiscovery started fine on " + this.config);
            }
            catch (Exception startupError) {
                if (!retry) {
                    WildFlyActiveMQLogger.LOGGER.xaRecoveryStartError(this.config);
                }
                this.stop();
                WildFlyActiveMQRecoveryRegistry.getInstance().failedDiscovery(this);
            }
        }
    }

    public synchronized void stop() {
        this.internalStop();
    }

    public int incrementUsage() {
        return this.usage.decrementAndGet();
    }

    public int decrementUsage() {
        return this.usage.incrementAndGet();
    }

    protected void finalize() {
        this.internalStop();
    }

    protected void internalStop() {
        if (this.started) {
            this.started = false;
            try {
                if (this.sessionFactory != null) {
                    this.sessionFactory.close();
                }
            }
            catch (Exception ignored) {
                WildFlyActiveMQLogger.LOGGER.debug(ignored, ignored);
            }
            try {
                this.locator.close();
            }
            catch (Exception ignored) {
                WildFlyActiveMQLogger.LOGGER.debug(ignored, ignored);
            }
            this.sessionFactory = null;
            this.locator = null;
        }
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        if (exception.getType() == ActiveMQExceptionType.DISCONNECTED) {
            WildFlyActiveMQLogger.LOGGER.warn("being disconnected for server shutdown", exception);
        } else {
            WildFlyActiveMQLogger.LOGGER.warn("Notified of connection failure in xa discovery, we will retry on the next recovery", exception);
        }
        this.internalStop();
        WildFlyActiveMQRecoveryRegistry.getInstance().failedDiscovery(this);
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    public String toString() {
        return "RecoveryDiscovery [config=" + this.config + ", started=" + this.started + "]";
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WildFlyRecoveryDiscovery)) {
            return false;
        }
        WildFlyRecoveryDiscovery discovery = (WildFlyRecoveryDiscovery)o;
        return this.config.equals((Object)discovery.config);
    }

    static final class InternalListener
    implements ClusterTopologyListener {
        private final XARecoveryConfig config;

        public InternalListener(XARecoveryConfig config) {
            this.config = config;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            if (topologyMember.getLive() != null) {
                Pair connector = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                WildFlyActiveMQRecoveryRegistry.getInstance().nodeUp(this.config, topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector, this.config.getUsername(), this.config.getPassword(), this.config.getProperties());
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }
}

