/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.fallback.FallbackContext;
import io.smallrye.faulttolerance.core.fallback.FallbackEvents;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.fallback.FallbackLogger;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;

public class Fallback<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final FallbackFunction<V> fallback;
    final SetOfThrowables applyOn;
    final SetOfThrowables skipOn;

    public Fallback(FaultToleranceStrategy<V> delegate, String description, FallbackFunction<V> fallback, SetOfThrowables applyOn, SetOfThrowables skipOn) {
        this.delegate = Preconditions.checkNotNull(delegate, "Fallback delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Fallback description must be set");
        this.fallback = Preconditions.checkNotNull(fallback, "Fallback function must be set");
        this.applyOn = Preconditions.checkNotNull(applyOn, "Set of apply-on throwables must be set");
        this.skipOn = Preconditions.checkNotNull(skipOn, "Set of skip-on throwables must be set");
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        FallbackLogger.LOG.trace("Fallback started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            FallbackLogger.LOG.trace("Fallback finished");
        }
    }

    private V doApply(InvocationContext<V> ctx) throws Exception {
        ctx.fireEvent(FallbackEvents.Defined.INSTANCE);
        try {
            return this.delegate.apply(ctx);
        }
        catch (Exception e) {
            Exception failure = e;
            if (failure instanceof InterruptedException || Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.shouldSkipFallback(failure)) {
                throw SneakyThrow.sneakyThrow(failure);
            }
            FallbackLogger.LOG.trace("Invocation failed, invoking fallback");
            ctx.fireEvent(FallbackEvents.Applied.INSTANCE);
            FallbackContext<V> fallbackContext = new FallbackContext<V>(failure, ctx);
            return this.fallback.call(fallbackContext);
        }
    }

    boolean shouldSkipFallback(Throwable e) {
        return this.skipOn.includes(e.getClass()) || !this.applyOn.includes(e.getClass());
    }
}

