/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.providers.PublisherDecorator;
import io.smallrye.reactive.messaging.providers.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.providers.extension.HealthCenter;
import io.smallrye.reactive.messaging.providers.helpers.BroadcastHelper;
import io.smallrye.reactive.messaging.providers.helpers.ConverterUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Subscriber;

public abstract class AbstractMediator {
    protected final MediatorConfiguration configuration;
    protected WorkerPoolRegistry workerPoolRegistry;
    private Invoker invoker;
    private Instance<PublisherDecorator> decorators;
    protected HealthCenter health;
    private Instance<MessageConverter> converters;

    public AbstractMediator(MediatorConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setDecorators(Instance<PublisherDecorator> decorators) {
        this.decorators = decorators;
    }

    public void setConverters(Instance<MessageConverter> converters) {
        this.converters = converters;
    }

    public void setWorkerPoolRegistry(WorkerPoolRegistry workerPoolRegistry) {
        this.workerPoolRegistry = workerPoolRegistry;
    }

    public void run() {
    }

    public void connectToUpstream(Multi<? extends Message<?>> publisher) {
    }

    public MediatorConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object bean) {
        AbstractMediator abstractMediator = this;
        synchronized (abstractMediator) {
            if (this.invoker == null) {
                this.invoker = args -> {
                    try {
                        return this.configuration.getMethod().invoke(bean, args);
                    }
                    catch (Exception e) {
                        throw ProviderExceptions.ex.processingException(this.configuration.methodAsString(), e);
                    }
                };
            }
        }
        Objects.requireNonNull(this.invoker, ProviderMessages.msg.invokerNotInitialized());
        if (this.configuration.isBlocking()) {
            Objects.requireNonNull(this.workerPoolRegistry, ProviderMessages.msg.workerPoolNotInitialized());
        }
    }

    protected <T> T invoke(Object ... args) {
        try {
            return (T)this.invoker.invoke(args);
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected <T> Uni<T> invokeOnMessageContext(Message<?> message, Object ... args) {
        return LocalContextMetadata.invokeOnMessageContext(message, x -> this.invoke(args));
    }

    protected <T> Uni<T> invokeBlocking(Message<?> message, Object ... args) {
        try {
            Optional metadata = message != null ? message.getMetadata().get(LocalContextMetadata.class) : Optional.empty();
            io.vertx.mutiny.core.Context currentContext = metadata.map(m -> io.vertx.mutiny.core.Context.newInstance((Context)m.context())).orElseGet(Vertx::currentContext);
            return this.workerPoolRegistry.executeWork(currentContext, Uni.createFrom().emitter(emitter -> {
                try {
                    Object result = this.invoker.invoke(args);
                    if (result instanceof CompletionStage) {
                        ((CompletionStage)result).thenAccept(x -> emitter.complete(x));
                    } else {
                        emitter.complete(result);
                    }
                }
                catch (RuntimeException e) {
                    ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
                    emitter.fail((Throwable)e);
                }
            }), this.configuration.getWorkerPoolName(), this.configuration.isBlockingExecutionOrdered());
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected CompletionStage<Message<?>> getAckOrCompletion(Message<?> message) {
        CompletionStage ack = message.ack();
        if (ack != null) {
            return ack.thenApply(x -> message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public Multi<? extends Message<?>> getStream() {
        return null;
    }

    public MediatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMethodAsString() {
        return this.configuration.methodAsString();
    }

    public Subscriber<Message<?>> getComputedSubscriber() {
        return null;
    }

    public abstract boolean isConnected();

    protected Function<Message<?>, ? extends CompletionStage<? extends Message<?>>> managePreProcessingAck() {
        return this::handlePreProcessingAck;
    }

    protected CompletionStage<Message<?>> handlePreProcessingAck(Message<?> message) {
        if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.PRE_PROCESSING) {
            return this.getAckOrCompletion(message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> input) {
        if (input == null) {
            return null;
        }
        for (PublisherDecorator decorator : this.decorators) {
            input = decorator.decorate(input, this.getConfiguration().getOutgoing());
        }
        if (this.configuration.getBroadcast()) {
            return BroadcastHelper.broadcastPublisher(input, this.configuration.getNumberOfSubscriberBeforeConnecting());
        }
        return input;
    }

    public void setHealth(HealthCenter health) {
        this.health = health;
    }

    public Multi<? extends Message<?>> convert(Multi<? extends Message<?>> upstream) {
        return ConverterUtils.convert(upstream, this.converters, this.configuration.getIngestedPayloadType());
    }
}

