/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Test;

public class JMSMessageCounterTest
extends JMSTestBase {
    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Test
    public void testMessageCounter() throws Exception {
        Connection conn = this.cf.createConnection();
        Session sess = conn.createSession(false, 1);
        Queue queue = this.createQueue(true, "Test");
        MessageProducer producer = sess.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = sess.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        conn.close();
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue." + queue.getQueueName());
        JMSMessageCounterTest.assertNotNull((Object)control);
        this.instanceLog.debug((Object)control.listMessageCounterAsHTML());
        this.jmsServer.stop();
        this.restartServer();
        control = (QueueControl)this.server.getManagementService().getResource("queue." + queue.getQueueName());
        JMSMessageCounterTest.assertNotNull((Object)control);
        this.instanceLog.debug((Object)control.listMessageCounterAsHTML());
    }
}

