/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.Assert;
import org.junit.Test;

public class SharedStoreBackupTest
extends FailoverTestBase {
    @Test
    public void testStartSharedBackupWithScalingDownPolicyDisabled() throws Exception {
        this.liveServer.stop();
        Assert.assertTrue((String)"Backup did not activate in 10s timeout.", (boolean)this.waitForBackupToBecomeActive(this.backupServer, 10000L));
    }

    private boolean waitForBackupToBecomeActive(TestableServer backupServer, long waitTimeout) throws Exception {
        boolean isBackupStarted;
        long startTime = System.currentTimeMillis();
        while (!(isBackupStarted = backupServer.isActive()) && System.currentTimeMillis() - startTime < waitTimeout) {
            Thread.sleep(300L);
        }
        return isBackupStarted;
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultConfig(false).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration().setEnabled(false)).setRestartBackup(false)).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(SharedStoreBackupTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])new String[]{liveConnector.getName()}));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.liveConfig = super.createDefaultConfig(false).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration().setFailoverOnServerShutdown(true)).addClusterConfiguration(SharedStoreBackupTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])new String[0])).addConnectorConfiguration(liveConnector.getName(), liveConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }
}

