/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.discovery;

import java.net.InetAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.tests.integration.discovery.DiscoveryBaseTest;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Before;
import org.junit.Test;

public class DiscoveryStayAliveTest
extends DiscoveryBaseTest {
    ScheduledExecutorService scheduledExecutorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ActiveMQThreadFactory("ActiveMQ-scheduled-threads", false, Thread.currentThread().getContextClassLoader()));
    }

    public void tearDown() throws Exception {
        this.scheduledExecutorService.shutdown();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiscoveryRunning() throws Throwable {
        int i;
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryStayAliveTest.getUDPDiscoveryPort();
        int timeout = 500;
        final DiscoveryGroup dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), InetAddress.getByName("localhost"), groupAddress, groupPort, 500L);
        final AtomicInteger errors = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    dg.internalRunning();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        t.start();
        BroadcastGroupImpl bg = null;
        try {
            bg = new BroadcastGroupImpl((NodeManager)new DiscoveryBaseTest.FakeNodeManager("test-nodeID"), RandomUtil.randomString(), 1L, this.scheduledExecutorService, (BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.address1).setGroupPort(groupPort));
            bg.start();
            bg.addConnector(this.generateTC());
            for (i = 0; i < 10; ++i) {
                UDPBroadcastEndpointFactory factoryEndpoint = new UDPBroadcastEndpointFactory().setGroupAddress(this.address1).setGroupPort(groupPort).setLocalBindAddress("localhost");
                DiscoveryStayAliveTest.sendBadData((BroadcastEndpointFactory)factoryEndpoint);
            }
            Thread.sleep(100L);
            DiscoveryStayAliveTest.assertTrue((boolean)t.isAlive());
            DiscoveryStayAliveTest.assertEquals((long)0L, (long)errors.get());
        }
        finally {
            if (bg != null) {
                bg.stop();
            }
            if (dg != null) {
                dg.stop();
            }
            t.join(1000L);
            for (i = 0; t.isAlive() && i < 100; ++i) {
                t.interrupt();
                Thread.sleep(100L);
            }
        }
    }

    private static void sendBadData(BroadcastEndpointFactory factoryEndpoint) throws Exception {
        BroadcastEndpoint endpoint = factoryEndpoint.createBroadcastEndpoint();
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)500);
        buffer.writeString("This is a test1!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        buffer.writeString("This is a test2!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        byte[] bytes = new byte[buffer.writerIndex()];
        buffer.readBytes(bytes);
        for (int i = bytes.length - 10; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
        endpoint.openBroadcaster();
        endpoint.broadcast(bytes);
        endpoint.close(true);
    }
}

