/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Before;
import org.junit.Test;

public class JmsTopicSelectorTest
extends BasicOpenWireTest {
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean topic = true;
    protected boolean durable;
    protected int deliveryMode = 2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        this.session = this.connection.createSession(false, 1);
        if (this.topic) {
            this.consumerDestination = this.createDestination(this.session, (byte)2);
            this.producerDestination = this.createDestination(this.session, (byte)2);
        } else {
            this.consumerDestination = this.createDestination(this.session, (byte)1);
            this.producerDestination = this.createDestination(this.session, (byte)1);
        }
        this.producer = this.session.createProducer(this.producerDestination);
        this.producer.setDeliveryMode(this.deliveryMode);
        this.connection.start();
    }

    protected MessageConsumer createConsumer(String selector) throws JMSException {
        if (this.durable) {
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName(), selector, false);
        }
        return this.session.createConsumer(this.consumerDestination, selector);
    }

    public void sendMessages() throws Exception {
        TextMessage message = this.session.createTextMessage("1");
        message.setIntProperty("id", 1);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("2");
        message.setIntProperty("id", 2);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", false);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("3");
        message.setIntProperty("id", 3);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("4");
        message.setIntProperty("id", 4);
        message.setJMSType("b");
        message.setStringProperty("stringProperty", "b");
        message.setLongProperty("longProperty", 2L);
        message.setBooleanProperty("booleanProperty", false);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("5");
        message.setIntProperty("id", 5);
        message.setJMSType("c");
        message.setStringProperty("stringProperty", "c");
        message.setLongProperty("longProperty", 3L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
    }

    public void consumeMessages(int remaining) throws Exception {
        this.consumer = this.createConsumer(null);
        for (int i = 0; i < remaining; ++i) {
            this.consumer.receive(1000L);
        }
        this.consumer.close();
    }

    @Test
    public void testEmptyPropertySelector() throws Exception {
        int remaining = 5;
        Message message = null;
        this.consumer = this.createConsumer("");
        this.sendMessages();
        while ((message = this.consumer.receive(1000L)) != null) {
            --remaining;
        }
        JmsTopicSelectorTest.assertEquals((long)remaining, (long)0L);
        this.consumer.close();
        this.consumeMessages(remaining);
    }

    @Test
    public void testPropertySelector() throws Exception {
        int remaining = 5;
        Message message = null;
        this.consumer = this.createConsumer("stringProperty = 'a' and longProperty = 1 and booleanProperty = true");
        this.sendMessages();
        while ((message = this.consumer.receive(1000L)) != null) {
            String text = ((TextMessage)message).getText();
            if (!text.equals("1") && !text.equals("3")) {
                JmsTopicSelectorTest.fail((String)("unexpected message: " + text));
            }
            --remaining;
        }
        JmsTopicSelectorTest.assertEquals((long)remaining, (long)3L);
        this.consumer.close();
        this.consumeMessages(remaining);
    }

    @Test
    public void testJMSPropertySelector() throws Exception {
        int remaining = 5;
        Message message = null;
        this.consumer = this.createConsumer("JMSType = 'a' and stringProperty = 'a'");
        this.sendMessages();
        while ((message = this.consumer.receive(1000L)) != null) {
            String text = ((TextMessage)message).getText();
            if (!(text.equals("1") || text.equals("2") || text.equals("3"))) {
                JmsTopicSelectorTest.fail((String)("unexpected message: " + text));
            }
            --remaining;
        }
        JmsTopicSelectorTest.assertEquals((long)remaining, (long)2L);
        this.consumer.close();
        this.consumeMessages(remaining);
    }
}

